/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine;

import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TieredEnergyMachine;
import com.gregtechceu.gtceu.api.machine.feature.ICleanroomProvider;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.feature.IMufflableMachine;
import com.gregtechceu.gtceu.api.machine.feature.IOverclockMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.IRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.machine.trait.MachineTrait;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableComputationContainer;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.mojang.blaze3d.MethodsReturnNonnullByDefault;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class WorkableTieredMachine
extends TieredEnergyMachine
implements IRecipeLogicMachine,
IMachineLife,
IMufflableMachine,
IOverclockMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(WorkableTieredMachine.class, TieredEnergyMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    @DescSynced
    public final RecipeLogic recipeLogic;
    public final GTRecipeType[] recipeTypes;
    @Persisted
    public int activeRecipeType = 0;
    public final Int2IntFunction tankScalingFunction;
    @Nullable
    private ICleanroomProvider cleanroom;
    @Persisted
    public final NotifiableItemStackHandler importItems;
    @Persisted
    public final NotifiableItemStackHandler exportItems;
    @Persisted
    public final NotifiableFluidTank importFluids;
    @Persisted
    public final NotifiableFluidTank exportFluids;
    @Persisted
    public final NotifiableComputationContainer importComputation;
    @Persisted
    public final NotifiableComputationContainer exportComputation;
    protected final Table<IO, RecipeCapability<?>, List<IRecipeHandler<?>>> capabilitiesProxy;
    @Persisted
    protected int overclockTier = this.getMaxOverclockTier();
    protected final List<ISubscription> traitSubscriptions;
    @Persisted
    @DescSynced
    protected boolean isMuffled;
    protected boolean previouslyMuffled = true;

    public WorkableTieredMachine(IMachineBlockEntity holder, int tier, Int2IntFunction tankScalingFunction, Object ... args) {
        super(holder, tier, args);
        this.recipeTypes = this.getDefinition().getRecipeTypes();
        this.tankScalingFunction = tankScalingFunction;
        this.capabilitiesProxy = Tables.newCustomTable(new EnumMap(IO.class), IdentityHashMap::new);
        this.traitSubscriptions = new ArrayList<ISubscription>();
        this.recipeLogic = this.createRecipeLogic(args);
        this.importItems = this.createImportItemHandler(args);
        this.exportItems = this.createExportItemHandler(args);
        this.importFluids = this.createImportFluidHandler(args);
        this.exportFluids = this.createExportFluidHandler(args);
        this.importComputation = this.createImportComputationContainer(args);
        this.exportComputation = this.createExportComputationContainer(args);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    protected NotifiableEnergyContainer createEnergyContainer(Object ... args) {
        long tierVoltage = GTValues.V[this.getTier()];
        if (this.isEnergyEmitter()) {
            return NotifiableEnergyContainer.emitterContainer(this, tierVoltage * 64L, tierVoltage, this.getMaxInputOutputAmperage());
        }
        return new NotifiableEnergyContainer(this, tierVoltage * 64L, tierVoltage, 2L, 0L, 0L){

            @Override
            public long getInputAmperage() {
                if (this.getEnergyCapacity() / 2L > this.getEnergyStored() && WorkableTieredMachine.this.recipeLogic.isActive()) {
                    return 2L;
                }
                return 1L;
            }
        };
    }

    protected NotifiableItemStackHandler createImportItemHandler(Object ... args) {
        return new NotifiableItemStackHandler(this, this.getRecipeType().getMaxInputs(ItemRecipeCapability.CAP), IO.IN);
    }

    protected NotifiableItemStackHandler createExportItemHandler(Object ... args) {
        return new NotifiableItemStackHandler(this, this.getRecipeType().getMaxOutputs(ItemRecipeCapability.CAP), IO.OUT);
    }

    protected NotifiableFluidTank createImportFluidHandler(Object ... args) {
        return new NotifiableFluidTank((MetaMachine)this, this.getRecipeType().getMaxInputs(FluidRecipeCapability.CAP), (Integer)this.tankScalingFunction.apply((Object)this.getTier()), IO.IN);
    }

    protected NotifiableFluidTank createExportFluidHandler(Object ... args) {
        return new NotifiableFluidTank((MetaMachine)this, this.getRecipeType().getMaxOutputs(FluidRecipeCapability.CAP), (Integer)this.tankScalingFunction.apply((Object)this.getTier()), IO.OUT);
    }

    protected NotifiableComputationContainer createImportComputationContainer(Object ... args) {
        Object object;
        boolean transmitter = true;
        if (args.length > 0 && (object = args[args.length - 1]) instanceof Boolean) {
            Boolean isTransmitter = (Boolean)object;
            transmitter = isTransmitter;
        }
        return new NotifiableComputationContainer(this, IO.IN, transmitter);
    }

    protected NotifiableComputationContainer createExportComputationContainer(Object ... args) {
        return new NotifiableComputationContainer(this, IO.OUT, false);
    }

    protected RecipeLogic createRecipeLogic(Object ... args) {
        return new RecipeLogic(this);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        for (MachineTrait trait : this.getTraits()) {
            if (!(trait instanceof IRecipeHandlerTrait)) continue;
            IRecipeHandlerTrait handlerTrait = (IRecipeHandlerTrait)((Object)trait);
            if (!this.capabilitiesProxy.contains((Object)handlerTrait.getHandlerIO(), handlerTrait.getCapability())) {
                this.capabilitiesProxy.put((Object)handlerTrait.getHandlerIO(), handlerTrait.getCapability(), new ArrayList());
            }
            ((List)this.capabilitiesProxy.get((Object)handlerTrait.getHandlerIO(), handlerTrait.getCapability())).add(handlerTrait);
            this.traitSubscriptions.add(handlerTrait.addChangedListener(this.recipeLogic::updateTickSubscription));
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        this.traitSubscriptions.forEach(ISubscription::unsubscribe);
        this.traitSubscriptions.clear();
        this.recipeLogic.inValid();
    }

    @Override
    protected long getMaxInputOutputAmperage() {
        return 2L;
    }

    @Override
    public void onMachineRemoved() {
        this.clearInventory((IItemHandlerModifiable)this.importItems.storage);
        this.clearInventory((IItemHandlerModifiable)this.exportItems.storage);
    }

    @Override
    public int getMaxOverclockTier() {
        return GTUtil.getTierByVoltage(Math.max(this.energyContainer.getInputVoltage(), this.energyContainer.getOutputVoltage()));
    }

    @Override
    public int getMinOverclockTier() {
        return 0;
    }

    @Override
    public void setOverclockTier(int tier) {
        if (!this.isRemote() && tier >= this.getMinOverclockTier() && tier <= this.getMaxOverclockTier()) {
            this.overclockTier = tier;
            this.recipeLogic.markLastRecipeDirty();
        }
    }

    @Override
    public long getOverclockVoltage() {
        return Math.min(GTValues.V[this.getOverclockTier()], Math.max(this.energyContainer.getInputVoltage(), this.energyContainer.getOutputVoltage()));
    }

    @Override
    public void clientTick() {
        super.clientTick();
        if (this.previouslyMuffled != this.isMuffled) {
            this.previouslyMuffled = this.isMuffled;
            if (this.recipeLogic != null) {
                this.recipeLogic.updateSound();
            }
        }
    }

    @Override
    public boolean keepSubscribing() {
        return false;
    }

    @Override
    @NotNull
    public GTRecipeType getRecipeType() {
        return this.recipeTypes[this.activeRecipeType];
    }

    @Override
    public RecipeLogic getRecipeLogic() {
        return this.recipeLogic;
    }

    @Override
    public GTRecipeType[] getRecipeTypes() {
        return this.recipeTypes;
    }

    @Override
    public int getActiveRecipeType() {
        return this.activeRecipeType;
    }

    @Override
    public void setActiveRecipeType(int activeRecipeType) {
        this.activeRecipeType = activeRecipeType;
    }

    public Int2IntFunction getTankScalingFunction() {
        return this.tankScalingFunction;
    }

    @Override
    @Nullable
    public ICleanroomProvider getCleanroom() {
        return this.cleanroom;
    }

    @Override
    public void setCleanroom(@Nullable ICleanroomProvider cleanroom) {
        this.cleanroom = cleanroom;
    }

    @Override
    public Table<IO, RecipeCapability<?>, List<IRecipeHandler<?>>> getCapabilitiesProxy() {
        return this.capabilitiesProxy;
    }

    @Override
    public int getOverclockTier() {
        return this.overclockTier;
    }

    @Override
    public boolean isMuffled() {
        return this.isMuffled;
    }

    @Override
    public void setMuffled(boolean isMuffled) {
        this.isMuffled = isMuffled;
    }
}

