/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.fluids.GTFluid;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import org.jetbrains.annotations.NotNull;

public class GTBucketItem
extends BucketItem {
    final Material material;
    final String langKey;

    public GTBucketItem(Supplier<? extends Fluid> fluid, Item.Properties properties, Material material, String langKey) {
        super(fluid, properties);
        this.material = material;
        this.langKey = langKey;
    }

    public static int color(ItemStack itemStack, int index) {
        Item item = itemStack.m_41720_();
        if (item instanceof GTBucketItem) {
            GTBucketItem item2 = (GTBucketItem)item;
            if (index == 1) {
                return IClientFluidTypeExtensions.of((Fluid)item2.getFluid()).getTintColor();
            }
        }
        return -1;
    }

    public ICapabilityProvider initCapabilities(@NotNull ItemStack stack, @Nullable CompoundTag nbt) {
        return ((Object)((Object)this)).getClass() == GTBucketItem.class ? new FluidBucketWrapper(stack) : super.initCapabilities(stack, nbt);
    }

    public String m_5524_() {
        return "item.gtceu.bucket";
    }

    public Component m_41466_() {
        MutableComponent materialName = this.material.getLocalizedName();
        return Component.m_237110_((String)"item.gtceu.bucket", (Object[])new Object[]{Component.m_237110_((String)this.langKey, (Object[])new Object[]{materialName})});
    }

    public Component m_7626_(ItemStack stack) {
        return this.m_41466_();
    }

    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        Fluid fluid;
        FluidProperty property = this.material.getProperty(PropertyKey.FLUID);
        if (property != null && (fluid = this.material.getFluid()) instanceof GTFluid) {
            GTFluid gtFluid = (GTFluid)fluid;
            return gtFluid.getBurnTime();
        }
        return -1;
    }

    public boolean emptyContents(@Nullable Player pPlayer, Level pLevel, BlockPos pPos, @Nullable BlockHitResult pResult, @Nullable ItemStack container) {
        if (!(this.getFluid() instanceof FlowingFluid)) {
            return false;
        }
        BlockState blockstate = pLevel.m_8055_(pPos);
        Block block = blockstate.m_60734_();
        boolean flag = blockstate.m_60722_(this.getFluid());
        boolean flag1 = blockstate.m_60795_() || flag || block instanceof LiquidBlockContainer && ((LiquidBlockContainer)block).m_6044_((BlockGetter)pLevel, pPos, blockstate, this.getFluid());
        Optional containedFluidStack = Optional.ofNullable(container).flatMap(FluidUtil::getFluidContained);
        if (!flag1) {
            return pResult != null && this.emptyContents(pPlayer, pLevel, pResult.m_82425_().m_121945_(pResult.m_82434_()), null, container);
        }
        if (containedFluidStack.isPresent() && this.getFluid().getFluidType().isVaporizedOnPlacement(pLevel, pPos, (FluidStack)containedFluidStack.get())) {
            this.getFluid().getFluidType().onVaporize(pPlayer, pLevel, pPos, (FluidStack)containedFluidStack.get());
            return true;
        }
        if (pLevel.m_6042_().f_63857_() && this.getFluid().m_205067_(FluidTags.f_13131_)) {
            int i = pPos.m_123341_();
            int j = pPos.m_123342_();
            int k = pPos.m_123343_();
            pLevel.m_5594_(pPlayer, pPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (pLevel.f_46441_.m_188501_() - pLevel.f_46441_.m_188501_()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (block instanceof LiquidBlockContainer && ((LiquidBlockContainer)block).m_6044_((BlockGetter)pLevel, pPos, blockstate, this.getFluid())) {
            ((LiquidBlockContainer)block).m_7361_((LevelAccessor)pLevel, pPos, blockstate, ((FlowingFluid)this.getFluid()).m_76068_(false));
            this.m_7718_(pPlayer, (LevelAccessor)pLevel, pPos);
            return true;
        }
        return false;
    }
}

