/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.texture;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.misc.PacketProspecting;
import com.gregtechceu.gtceu.api.gui.misc.ProspectorMode;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.lang.reflect.Array;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class ProspectingTexture
extends AbstractTexture {
    public static final String SELECTED_ALL = "[all]";
    private String selected = "[all]";
    private boolean darkMode;
    private final int imageWidth;
    private final int imageHeight;
    public final Object[][][] data;
    private final int playerXGui;
    private final int playerYGui;
    private final float direction;
    private final int playerChunkX;
    private final int playerChunkZ;
    private final ProspectorMode mode;
    private final int radius;

    public ProspectingTexture(int playerChunkX, int playerChunkZ, int posX, int posZ, float direction, ProspectorMode mode, int radius, boolean darkMode) {
        this.darkMode = darkMode;
        this.radius = radius;
        this.mode = mode;
        this.data = (Object[][][])Array.newInstance(mode.getItemClass(), (radius * 2 - 1) * mode.cellSize, (radius * 2 - 1) * mode.cellSize, 0);
        this.imageWidth = (radius * 2 - 1) * 16;
        this.imageHeight = (radius * 2 - 1) * 16;
        this.playerChunkX = playerChunkX;
        this.playerChunkZ = playerChunkZ;
        this.direction = (direction + 180.0f) % 360.0f;
        this.playerXGui = posX - (playerChunkX - this.radius + 1) * 16 + (posX > 0 ? 1 : 0);
        this.playerYGui = posZ - (playerChunkZ - this.radius + 1) * 16 + (posX > 0 ? 1 : 0);
    }

    public void updateTexture(PacketProspecting packet) {
        int ox = packet.chunkX > 0 && this.playerChunkX > 0 || packet.chunkX < 0 && this.playerChunkX < 0 ? Math.abs(Math.abs(packet.chunkX) - Math.abs(this.playerChunkX)) : Math.abs(this.playerChunkX) + Math.abs(packet.chunkX);
        if (this.playerChunkX > packet.chunkX) {
            ox = -ox;
        }
        int oy = packet.chunkZ > 0 && this.playerChunkZ > 0 || packet.chunkZ < 0 && this.playerChunkZ < 0 ? Math.abs(Math.abs(packet.chunkZ) - Math.abs(this.playerChunkZ)) : Math.abs(this.playerChunkZ) + Math.abs(packet.chunkZ);
        if (this.playerChunkZ > packet.chunkZ) {
            oy = -oy;
        }
        int currentColumn = this.radius - 1 + ox;
        int currentRow = this.radius - 1 + oy;
        if (currentRow < 0) {
            return;
        }
        for (int x = 0; x < this.mode.cellSize; ++x) {
            System.arraycopy(packet.data[x], 0, this.data[x + currentColumn * this.mode.cellSize], currentRow * this.mode.cellSize, this.mode.cellSize);
        }
        this.load();
    }

    private NativeImage getImage() {
        int wh = (this.radius * 2 - 1) * 16;
        NativeImage image = new NativeImage(wh, wh, false);
        for (int i = 0; i < wh; ++i) {
            for (int j = 0; j < wh; ++j) {
                Object[] items = this.data[i * this.mode.cellSize / 16][j * this.mode.cellSize / 16];
                image.m_84988_(i, j, this.darkMode ? ColorPattern.GRAY.color : ColorPattern.WHITE.color);
                for (Object item : items) {
                    if (!this.selected.equals(SELECTED_ALL) && !this.selected.equals(this.mode.getUniqueID(item))) continue;
                    int color = this.mode.getItemColor(item);
                    image.m_84988_(i, j, ProspectingTexture.combine(255, ColorUtils.blueI((int)color), ColorUtils.greenI((int)color), ColorUtils.redI((int)color)));
                    break;
                }
                if (i % 16 != 0 && j % 16 != 0) continue;
                image.m_84988_(i, j, ColorUtils.averageColor((int[])new int[]{image.m_84985_(i, j), -16777216}));
            }
        }
        return image;
    }

    public static int combine(int alpha, int blue, int green, int red) {
        return (alpha & 0xFF) << 24 | (blue & 0xFF) << 16 | (green & 0xFF) << 8 | (red & 0xFF) << 0;
    }

    public void load() {
        this.doLoad(this.getImage());
    }

    private void doLoad(NativeImage image) {
        TextureUtil.prepareImage((int)this.m_117963_(), (int)0, (int)image.m_84982_(), (int)image.m_85084_());
        image.m_85013_(0, 0, 0, 0, 0, image.m_84982_(), image.m_85084_(), false, false, false, true);
    }

    public void draw(GuiGraphics graphics, int x, int y) {
        if (this.m_117963_() == -1) {
            return;
        }
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (int)this.m_117963_());
        Matrix4f matrix4f = graphics.m_280168_().m_85850_().m_252922_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferbuilder.m_252986_(matrix4f, (float)x, (float)(y + this.imageHeight), 0.0f).m_7421_(0.0f, 1.0f).m_193479_(-1).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)(x + this.imageWidth), (float)(y + this.imageHeight), 0.0f).m_7421_(1.0f, 1.0f).m_193479_(-1).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)(x + this.imageWidth), (float)y, 0.0f).m_7421_(1.0f, 0.0f).m_193479_(-1).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)x, (float)y, 0.0f).m_7421_(0.0f, 0.0f).m_193479_(-1).m_5752_();
        tessellator.m_85914_();
        for (int cx = 0; cx < this.radius * 2 - 1; ++cx) {
            for (int cz = 0; cz < this.radius * 2 - 1; ++cz) {
                if (this.data[cx][cz] == null || this.data[cx][cz].length <= 0) continue;
                Object[] items = this.data[cx][cz];
                this.mode.drawSpecialGrid(graphics, items, x + cx * 16 + 1, y + cz * 16 + 1, 16, 16);
            }
        }
        GuiTextures.UP.copy().setColor(ColorPattern.RED.color).rotate(this.direction / 2.0f).draw(graphics, 0, 0, (float)(x + this.playerXGui - 20), (float)(y + this.playerYGui - 20), 40, 40);
        if (this.playerXGui % 16 > 7 || this.playerXGui % 16 == 0) {
            DrawerHelper.drawSolidRect((GuiGraphics)graphics, (int)(x + this.playerXGui - 1), (int)y, (int)1, (int)this.imageHeight, (int)ColorPattern.RED.color);
        } else {
            DrawerHelper.drawSolidRect((GuiGraphics)graphics, (int)(x + this.playerXGui), (int)y, (int)1, (int)this.imageHeight, (int)ColorPattern.RED.color);
        }
        if (this.playerYGui % 16 > 7 || this.playerYGui % 16 == 0) {
            DrawerHelper.drawSolidRect((GuiGraphics)graphics, (int)x, (int)(y + this.playerYGui - 1), (int)this.imageWidth, (int)1, (int)ColorPattern.RED.color);
        } else {
            DrawerHelper.drawSolidRect((GuiGraphics)graphics, (int)x, (int)(y + this.playerYGui), (int)this.imageWidth, (int)1, (int)ColorPattern.RED.color);
        }
    }

    public void m_6704_(ResourceManager resourceManager) throws IOException {
    }

    public void setDarkMode(boolean darkMode) {
        if (this.darkMode != darkMode) {
            this.darkMode = darkMode;
            this.load();
        }
    }

    public void setSelected(String uniqueID) {
        if (!this.selected.equals(uniqueID)) {
            this.selected = uniqueID;
            this.load();
        }
    }

    public String getSelected() {
        return this.selected;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }
}

