/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.ores;

import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedIndicators;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVein;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreBlockPlacer;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreGenCache;
import com.gregtechceu.gtceu.config.ConfigHolder;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class OrePlacer {
    private final OreGenCache oreGenCache = new OreGenCache();

    public void placeOres(WorldGenLevel level, ChunkGenerator chunkGenerator, ChunkAccess chunk) {
        if (!ConfigHolder.INSTANCE.dev.doSuperflatOres && chunkGenerator instanceof FlatLevelSource) {
            return;
        }
        XoroshiroRandomSource random = new XoroshiroRandomSource(level.m_7328_() ^ chunk.m_7697_().m_45588_());
        List<GeneratedVein> generatedVeins = this.oreGenCache.consumeChunkVeins(level, chunkGenerator, chunk);
        List<GeneratedIndicators> generatedIndicators = this.oreGenCache.consumeChunkIndicators(level, chunkGenerator, chunk);
        try (BulkSectionAccess access = new BulkSectionAccess((LevelAccessor)level);){
            generatedVeins.forEach(generatedVein -> this.placeVein(chunk.m_7697_(), (RandomSource)random, access, (GeneratedVein)generatedVein, null));
            generatedIndicators.forEach(generatedIndicator -> this.placeIndicators(chunk, access, (GeneratedIndicators)generatedIndicator));
        }
    }

    public void placeVein(ChunkPos chunk, RandomSource random, BulkSectionAccess access, GeneratedVein generatedVein, @Nullable RuleTest targetOverride) {
        RuleTest layerTarget = targetOverride != null ? targetOverride : generatedVein.getLayer().getTarget();
        this.resolvePlacerLists(chunk, generatedVein).forEach((sectionPos, placers) -> {
            LevelChunkSection section = access.m_156104_(sectionPos.m_123249_());
            if (section == null) {
                return;
            }
            placers.forEach((pos, placer) -> {
                BlockState blockState = section.m_62982_(SectionPos.m_123207_((int)pos.m_123341_()), SectionPos.m_123207_((int)pos.m_123342_()), SectionPos.m_123207_((int)pos.m_123343_()));
                if (layerTarget.m_213865_(blockState, random)) {
                    placer.placeBlock(access, section);
                }
            });
        });
    }

    private Map<SectionPos, Map<BlockPos, OreBlockPlacer>> resolvePlacerLists(ChunkPos chunk, GeneratedVein vein) {
        return vein.consumeOres(chunk).entrySet().stream().collect(Collectors.groupingBy(entry -> SectionPos.m_123199_((BlockPos)((BlockPos)entry.getKey())), Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    private void placeIndicators(ChunkAccess chunk, BulkSectionAccess access, GeneratedIndicators generatedVein) {
        generatedVein.consumeIndicators(chunk.m_7697_()).forEach(placer -> placer.placeIndicators(access));
    }

    public OreGenCache getOreGenCache() {
        return this.oreGenCache;
    }
}

