/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.generator.veins;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.generator.VeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreBlockPlacer;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreVeinUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class DikeVeinGenerator
extends VeinGenerator {
    public static final Codec<DikeVeinGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(DikeBlockDefinition.CODEC).fieldOf("blocks").forGetter(it -> it.blocks), (App)Codec.INT.fieldOf("min_y").forGetter(it -> it.minYLevel), (App)Codec.INT.fieldOf("max_y").forGetter(it -> it.maxYLevel)).apply((Applicative)instance, DikeVeinGenerator::new));
    public List<DikeBlockDefinition> blocks;
    public int minYLevel;
    public int maxYLevel;

    public DikeVeinGenerator(GTOreDefinition entry) {
        super(entry);
    }

    @Override
    public List<Map.Entry<Either<BlockState, Material>, Integer>> getAllEntries() {
        return this.blocks.stream().flatMap(definition -> (Stream)definition.block.map(state -> state.stream().map(target -> Map.entry(Either.left((Object)target.f_161033_), definition.weight)), material -> Stream.of(Map.entry(Either.right((Object)material), definition.weight)))).collect(Collectors.toList());
    }

    @Override
    public Map<BlockPos, OreBlockPlacer> generate(WorldGenLevel level, RandomSource random, GTOreDefinition entry, BlockPos origin) {
        Object2ObjectOpenHashMap generatedBlocks = new Object2ObjectOpenHashMap();
        WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(level.m_7328_()));
        NormalNoise normalNoise = NormalNoise.m_230504_((RandomSource)worldgenRandom, (int)-2, (double[])new double[]{4.0});
        ChunkPos chunkPos = new ChunkPos(origin);
        float density = entry.density();
        int size = entry.clusterSize().m_214085_(random);
        int radius = Mth.m_14167_((float)((float)size / 2.0f));
        int xPos = chunkPos.m_45604_() + level.m_213780_().m_188503_(16);
        int zPos = chunkPos.m_45605_() + level.m_213780_().m_188503_(16);
        int yTop = this.maxYLevel;
        int yBottom = this.minYLevel;
        BlockPos basePos = new BlockPos(xPos, yBottom, zPos);
        for (int dY = yBottom; dY <= yTop; ++dY) {
            for (int dX = -radius; dX <= radius; ++dX) {
                for (int dZ = -radius; dZ <= radius; ++dZ) {
                    float dist = dX * dX + dZ * dZ;
                    if (dist > (float)(radius * 2)) continue;
                    BlockPos pos = new BlockPos(basePos.m_123341_() + dX, dY, basePos.m_123343_() + dZ);
                    if (!(normalNoise.m_75380_((double)dX, (double)dY, (double)dZ) >= 0.5) || !(random.m_188501_() <= density)) continue;
                    long randomSeed = random.m_188505_();
                    generatedBlocks.put(pos, (access, section) -> this.placeBlock(access, section, randomSeed, pos, entry));
                }
            }
        }
        return generatedBlocks;
    }

    private void placeBlock(BulkSectionAccess level, LevelChunkSection section, long randomSeed, BlockPos pos, GTOreDefinition entry) {
        XoroshiroRandomSource rand = new XoroshiroRandomSource(randomSeed);
        List<Map.Entry> entries = this.blocks.stream().map(b -> Map.entry(b.weight, b)).toList();
        DikeBlockDefinition blockDefinition = this.blocks.get(GTUtil.getRandomItem((RandomSource)rand, entries, entries.size()));
        BlockState current = level.m_156110_(pos);
        int x = SectionPos.m_123207_((int)pos.m_123341_());
        int y = SectionPos.m_123207_((int)pos.m_123342_());
        int z = SectionPos.m_123207_((int)pos.m_123343_());
        if (pos.m_123342_() >= blockDefinition.minY() && pos.m_123342_() <= blockDefinition.maxY()) {
            blockDefinition.block.ifLeft(blockStates -> {
                for (OreConfiguration.TargetBlockState targetState : blockStates) {
                    if (!OreVeinUtil.canPlaceOre(current, arg_0 -> ((BulkSectionAccess)level).m_156110_(arg_0), (RandomSource)rand, entry, targetState, (BlockPos)pos.m_122032_()) || targetState.f_161033_.m_60795_()) continue;
                    section.m_62991_(x, y, z, targetState.f_161033_, false);
                    break;
                }
            }).ifRight(material -> {
                if (!OreVeinUtil.canPlaceOre(current, arg_0 -> ((BulkSectionAccess)level).m_156110_(arg_0), (RandomSource)rand, entry, (BlockPos)pos.m_122032_())) {
                    return;
                }
                BlockState currentState = level.m_156110_(pos);
                Optional<TagPrefix> prefix = ChemicalHelper.getOrePrefix(currentState);
                if (prefix.isEmpty()) {
                    return;
                }
                Block toPlace = ChemicalHelper.getBlock(prefix.get(), material);
                if (toPlace == null || toPlace.m_49966_().m_60795_()) {
                    return;
                }
                section.m_62991_(x, y, z, toPlace.m_49966_(), false);
            });
        }
    }

    @Override
    public VeinGenerator build() {
        return this;
    }

    @Override
    public VeinGenerator copy() {
        return new DikeVeinGenerator(new ArrayList<DikeBlockDefinition>(this.blocks), this.minYLevel, this.maxYLevel);
    }

    @Override
    public Codec<? extends VeinGenerator> codec() {
        return CODEC;
    }

    public DikeVeinGenerator withBlock(Material block, int weight, int minY, int maxY) {
        return this.withBlock(new DikeBlockDefinition(block, weight, minY, maxY));
    }

    public DikeVeinGenerator withBlock(BlockState blockState, int weight, int minY, int maxY) {
        OreConfiguration.TargetBlockState target = OreConfiguration.m_161021_((RuleTest)AlwaysTrueTest.f_73954_, (BlockState)blockState);
        return this.withBlock(new DikeBlockDefinition(List.of(target), weight, minY, maxY));
    }

    public DikeVeinGenerator withBlock(DikeBlockDefinition block) {
        if (this.blocks == null) {
            this.blocks = new ArrayList<DikeBlockDefinition>();
        }
        this.blocks.add(block);
        return this;
    }

    public DikeVeinGenerator(List<DikeBlockDefinition> blocks, int minYLevel, int maxYLevel) {
        this.blocks = blocks;
        this.minYLevel = minYLevel;
        this.maxYLevel = maxYLevel;
    }

    public DikeVeinGenerator minYLevel(int minYLevel) {
        this.minYLevel = minYLevel;
        return this;
    }

    public DikeVeinGenerator maxYLevel(int maxYLevel) {
        this.maxYLevel = maxYLevel;
        return this;
    }

    public record DikeBlockDefinition(Either<List<OreConfiguration.TargetBlockState>, Material> block, int weight, int minY, int maxY) {
        public static final Codec<DikeBlockDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either((Codec)OreConfiguration.TargetBlockState.f_161031_.listOf(), GTCEuAPI.materialManager.codec()).fieldOf("block").forGetter(x -> x.block), (App)Codec.INT.fieldOf("weight").forGetter(x -> x.weight), (App)Codec.INT.fieldOf("min_y").orElse((Object)320).forGetter(x -> x.minY), (App)Codec.INT.fieldOf("max_y").orElse((Object)-64).forGetter(x -> x.maxY)).apply((Applicative)instance, DikeBlockDefinition::new));

        public DikeBlockDefinition(Material block, int weight, int minY, int maxY) {
            this((Either<List<OreConfiguration.TargetBlockState>, Material>)Either.right((Object)block), weight, minY, maxY);
        }

        public DikeBlockDefinition(List<OreConfiguration.TargetBlockState> block, int weight, int minY, int maxY) {
            this((Either<List<OreConfiguration.TargetBlockState>, Material>)Either.left(block), weight, minY, maxY);
        }
    }
}

