/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid;

import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.BedrockFluidDefinition;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.config.ConfigHolder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidVeinWorldEntry {
    @Nullable
    private BedrockFluidDefinition vein;
    private int fluidYield;
    private int operationsRemaining;

    public FluidVeinWorldEntry(@Nullable BedrockFluidDefinition vein, int fluidYield, int operationsRemaining) {
        this.vein = vein;
        this.fluidYield = fluidYield;
        this.operationsRemaining = operationsRemaining;
    }

    private FluidVeinWorldEntry() {
    }

    public BedrockFluidDefinition getDefinition() {
        return this.vein;
    }

    public void setOperationsRemaining(int amount) {
        this.operationsRemaining = amount;
    }

    public void decreaseOperations(int amount) {
        this.operationsRemaining = ConfigHolder.INSTANCE.worldgen.oreVeins.infiniteBedrockOresFluids ? this.operationsRemaining : Math.max(0, this.operationsRemaining - amount);
    }

    public CompoundTag writeToNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("fluidYield", this.fluidYield);
        tag.m_128405_("operationsRemaining", this.operationsRemaining);
        if (this.vein != null && GTRegistries.BEDROCK_FLUID_DEFINITIONS.getKey(this.vein) != null) {
            tag.m_128359_("vein", ((ResourceLocation)GTRegistries.BEDROCK_FLUID_DEFINITIONS.getKey(this.vein)).toString());
        }
        return tag;
    }

    @NotNull
    public static FluidVeinWorldEntry readFromNBT(@NotNull CompoundTag tag) {
        ResourceLocation id;
        FluidVeinWorldEntry info = new FluidVeinWorldEntry();
        info.fluidYield = tag.m_128451_("fluidYield");
        info.operationsRemaining = tag.m_128451_("operationsRemaining");
        if (tag.m_128441_("vein") && GTRegistries.BEDROCK_FLUID_DEFINITIONS.containKey(id = new ResourceLocation(tag.m_128461_("vein")))) {
            info.vein = (BedrockFluidDefinition)GTRegistries.BEDROCK_FLUID_DEFINITIONS.get(id);
        }
        return info;
    }

    @Nullable
    public BedrockFluidDefinition getVein() {
        return this.vein;
    }

    public int getFluidYield() {
        return this.fluidYield;
    }

    public int getOperationsRemaining() {
        return this.operationsRemaining;
    }
}

