/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.chemical.material.stack;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import java.util.Map;
import java.util.WeakHashMap;

public record MaterialStack(Material material, long amount) {
    private static final Map<String, MaterialStack> PARSE_CACHE = new WeakHashMap<String, MaterialStack>();

    public MaterialStack copy(long amount) {
        return new MaterialStack(this.material, amount);
    }

    public MaterialStack copy() {
        return new MaterialStack(this.material, this.amount);
    }

    public static MaterialStack fromString(CharSequence str) {
        String trimmed;
        String copy = trimmed = str.toString().trim();
        MaterialStack cached = PARSE_CACHE.get(trimmed);
        if (cached != null) {
            return cached.isEmpty() ? null : cached.copy();
        }
        int count = 1;
        int spaceIndex = copy.indexOf(32);
        if (spaceIndex >= 2 && copy.indexOf(120) == spaceIndex - 1) {
            count = Integer.parseInt(copy.substring(0, spaceIndex - 1));
            copy = copy.substring(spaceIndex + 1);
        }
        cached = new MaterialStack(GTMaterials.get(copy), count);
        PARSE_CACHE.put(trimmed, cached);
        return cached.copy();
    }

    public boolean isEmpty() {
        return this.material == GTMaterials.Air || this.amount < 1L;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaterialStack that = (MaterialStack)o;
        if (this.amount != that.amount) {
            return false;
        }
        return this.material.equals(that.material);
    }

    @Override
    public int hashCode() {
        return this.material.hashCode() * 31 + (int)this.amount * 31;
    }

    @Override
    public String toString() {
        Object string = "";
        string = this.material.getChemicalFormula().isEmpty() ? (String)string + "?" : (this.material.getMaterialComponents().size() > 1 ? (String)string + "(" + this.material.getChemicalFormula() + ")" : (String)string + this.material.getChemicalFormula());
        if (this.amount > 1L) {
            string = (String)string + FormattingUtil.toSmallDownNumbers(Long.toString(this.amount));
        }
        return string;
    }
}

