/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.chemical.material.properties;

import com.gregtechceu.gtceu.api.data.chemical.material.properties.IMaterialProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.MaterialProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;

public class BlastProperty
implements IMaterialProperty {
    private int blastTemperature;
    private GasTier gasTier = null;
    private int durationOverride = -1;
    private int EUtOverride = -1;
    private int vacuumDurationOverride = -1;
    private int vacuumEUtOverride = -1;

    public BlastProperty(int blastTemperature) {
        this.blastTemperature = blastTemperature;
    }

    public BlastProperty(int blastTemperature, GasTier gasTier) {
        this.blastTemperature = blastTemperature;
        this.gasTier = gasTier;
    }

    public BlastProperty(int blastTemperature, GasTier gasTier, int eutOverride, int durationOverride, int vacuumEUtOverride, int vacuumDurationOverride) {
        this.blastTemperature = blastTemperature;
        this.gasTier = gasTier;
        this.EUtOverride = eutOverride;
        this.durationOverride = durationOverride;
        this.vacuumEUtOverride = vacuumEUtOverride;
        this.vacuumDurationOverride = vacuumDurationOverride;
    }

    public BlastProperty() {
        this(0);
    }

    public void setBlastTemperature(int blastTemp) {
        if (blastTemp <= 0) {
            throw new IllegalArgumentException("Blast Temperature must be greater than zero!");
        }
        this.blastTemperature = blastTemp;
    }

    @Override
    public void verifyProperty(MaterialProperties properties) {
        properties.ensureSet(PropertyKey.INGOT, true);
    }

    public static GasTier validateGasTier(String gasTierName) {
        if (gasTierName == null) {
            return null;
        }
        if ("LOW".equalsIgnoreCase(gasTierName)) {
            return GasTier.LOW;
        }
        if ("MID".equalsIgnoreCase(gasTierName)) {
            return GasTier.MID;
        }
        if ("HIGH".equalsIgnoreCase(gasTierName)) {
            return GasTier.HIGH;
        }
        if ("HIGHER".equalsIgnoreCase(gasTierName)) {
            return GasTier.HIGHER;
        }
        if ("HIGHEST".equalsIgnoreCase(gasTierName)) {
            return GasTier.HIGHEST;
        }
        String message = "Gas Tier must be either \"LOW\", \"MID\", \"HIGH\", \"HIGHER\", or \"HIGHEST\"";
        throw new IllegalArgumentException("Could not find valid gas tier for name: " + gasTierName + ". " + message);
    }

    public int getBlastTemperature() {
        return this.blastTemperature;
    }

    public void setGasTier(GasTier gasTier) {
        this.gasTier = gasTier;
    }

    public GasTier getGasTier() {
        return this.gasTier;
    }

    public void setDurationOverride(int durationOverride) {
        this.durationOverride = durationOverride;
    }

    public int getDurationOverride() {
        return this.durationOverride;
    }

    public void setEUtOverride(int EUtOverride) {
        this.EUtOverride = EUtOverride;
    }

    public int getEUtOverride() {
        return this.EUtOverride;
    }

    public void setVacuumDurationOverride(int vacuumDurationOverride) {
        this.vacuumDurationOverride = vacuumDurationOverride;
    }

    public int getVacuumDurationOverride() {
        return this.vacuumDurationOverride;
    }

    public void setVacuumEUtOverride(int vacuumEUtOverride) {
        this.vacuumEUtOverride = vacuumEUtOverride;
    }

    public int getVacuumEUtOverride() {
        return this.vacuumEUtOverride;
    }

    public static enum GasTier {
        LOW,
        MID,
        HIGH,
        HIGHER,
        HIGHEST;

        public static final GasTier[] VALUES;

        static {
            VALUES = GasTier.values();
        }
    }

    public static class Builder {
        private int temp;
        private GasTier gasTier;
        private int eutOverride = -1;
        private int durationOverride = -1;
        private int vacuumEUtOverride = -1;
        private int vacuumDurationOverride = -1;

        public Builder temp(int temperature) {
            this.temp = temperature;
            return this;
        }

        public Builder temp(int temperature, GasTier gasTier) {
            this.temp = temperature;
            this.gasTier = gasTier;
            return this;
        }

        public Builder blastStats(int eutOverride) {
            this.eutOverride = eutOverride;
            return this;
        }

        public Builder blastStats(int eutOverride, int durationOverride) {
            this.eutOverride = eutOverride;
            this.durationOverride = durationOverride;
            return this;
        }

        public Builder vacuumStats(int eutOverride) {
            this.vacuumEUtOverride = eutOverride;
            return this;
        }

        public Builder vacuumStats(int eutOverride, int durationOverride) {
            this.vacuumEUtOverride = eutOverride;
            this.vacuumDurationOverride = durationOverride;
            return this;
        }

        public BlastProperty build() {
            return new BlastProperty(this.temp, this.gasTier, this.eutOverride, this.durationOverride, this.vacuumEUtOverride, this.vacuumDurationOverride);
        }
    }
}

