/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.chemical.material.properties;

import com.google.common.base.Preconditions;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IMaterialProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.MaterialProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.data.recipe.misc.alloyblast.AlloyBlastRecipeProducer;
import java.util.function.Supplier;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public class AlloyBlastProperty
implements IMaterialProperty {
    private Supplier<? extends Fluid> fluidSupplier;
    private int temperature;
    @NotNull
    private AlloyBlastRecipeProducer recipeProducer = AlloyBlastRecipeProducer.DEFAULT_PRODUCER;

    public AlloyBlastProperty(int temperature) {
        this.temperature = temperature;
    }

    @Override
    public void verifyProperty(MaterialProperties materialProperties) {
        materialProperties.ensureSet(PropertyKey.BLAST);
        materialProperties.ensureSet(PropertyKey.FLUID);
        this.temperature = materialProperties.getProperty(PropertyKey.BLAST).getBlastTemperature();
    }

    public void setFluid(@NotNull Supplier<? extends Fluid> materialFluid) {
        Preconditions.checkNotNull(materialFluid);
        this.fluidSupplier = materialFluid;
    }

    public Fluid getFluid() {
        return this.fluidSupplier.get();
    }

    public void setTemperature(int fluidTemperature) {
        Preconditions.checkArgument((fluidTemperature > 0 ? 1 : 0) != 0, (Object)"Invalid temperature");
        this.temperature = fluidTemperature;
    }

    public int getTemperature() {
        return this.temperature;
    }

    @NotNull
    public AlloyBlastRecipeProducer getRecipeProducer() {
        return this.recipeProducer;
    }

    public void setRecipeProducer(@NotNull AlloyBlastRecipeProducer recipeProducer) {
        if (recipeProducer == null) {
            throw new NullPointerException("recipeProducer is marked non-null but is null");
        }
        this.recipeProducer = recipeProducer;
    }
}

