/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.cover.filter;

import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.cover.filter.ItemFilter;
import com.gregtechceu.gtceu.api.gui.widget.EnumSelectorWidget;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.lookup.AbstractMapIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.GTRecipeLookup;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.utils.ItemStackHashStrategy;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class SmartItemFilter
implements ItemFilter {
    protected Consumer<ItemFilter> itemWriter = filter -> {};
    protected Consumer<ItemFilter> onUpdated = filter -> this.itemWriter.accept((ItemFilter)filter);
    private SmartFilteringMode filterMode = SmartFilteringMode.ELECTROLYZER;

    protected SmartItemFilter() {
    }

    public static SmartItemFilter loadFilter(ItemStack itemStack) {
        return SmartItemFilter.loadFilter(itemStack.m_41784_(), filter -> itemStack.m_41751_(filter.saveFilter()));
    }

    private static SmartItemFilter loadFilter(CompoundTag tag, Consumer<ItemFilter> itemWriter) {
        SmartItemFilter handler = new SmartItemFilter();
        handler.itemWriter = itemWriter;
        handler.filterMode = SmartFilteringMode.VALUES[tag.m_128451_("filterMode")];
        return handler;
    }

    @Override
    public void setOnUpdated(Consumer<ItemFilter> onUpdated) {
        this.onUpdated = filter -> {
            this.itemWriter.accept((ItemFilter)filter);
            onUpdated.accept((ItemFilter)filter);
        };
    }

    @Override
    public CompoundTag saveFilter() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("filterMode", this.filterMode.ordinal());
        return tag;
    }

    private void setFilterMode(SmartFilteringMode filterMode) {
        this.filterMode = filterMode;
        this.onUpdated.accept(this);
    }

    @Override
    public WidgetGroup openConfigurator(int x, int y) {
        WidgetGroup group = new WidgetGroup(x, y, 79, 54);
        group.addWidget((Widget)new EnumSelectorWidget(16, 8, 32, 32, (Enum[])SmartFilteringMode.VALUES, (Enum)this.filterMode, this::setFilterMode));
        return group;
    }

    @Override
    public boolean test(ItemStack itemStack) {
        return this.testItemCount(itemStack) > 0;
    }

    @Override
    public int testItemCount(ItemStack itemStack) {
        return this.filterMode.cache.computeIfAbsent((Object)itemStack, this::lookup);
    }

    private int lookup(ItemStack itemStack) {
        ItemStack copy = itemStack.m_255036_(Integer.MAX_VALUE);
        List<AbstractMapIngredient> ingredients = ItemRecipeCapability.CAP.convertToMapIngredient(copy);
        GTRecipe recipe = this.filterMode.lookup.recurseIngredientTreeFindRecipe(List.of(ingredients), this.filterMode.lookup.getLookup(), r -> true);
        if (recipe == null) {
            return 0;
        }
        for (Content content : recipe.getInputContents(ItemRecipeCapability.CAP)) {
            ItemStack[] stacks;
            for (ItemStack stack : stacks = ((Ingredient)ItemRecipeCapability.CAP.of(content.getContent())).m_43908_()) {
                if (!ItemStack.m_41656_((ItemStack)stack, (ItemStack)itemStack)) continue;
                return stack.m_41613_();
            }
        }
        return 0;
    }

    public void setModeFromMachine(String machineName) {
        for (SmartFilteringMode mode : SmartFilteringMode.VALUES) {
            if (!machineName.contains(mode.localeName)) continue;
            this.setFilterMode(mode);
            return;
        }
    }

    @MethodsReturnNonnullByDefault
    private static enum SmartFilteringMode implements EnumSelectorWidget.SelectableEnum
    {
        ELECTROLYZER("electrolyzer", GTRecipeTypes.ELECTROLYZER_RECIPES),
        CENTRIFUGE("centrifuge", GTRecipeTypes.CENTRIFUGE_RECIPES),
        SIFTER("sifter", GTRecipeTypes.SIFTER_RECIPES);

        private static final SmartFilteringMode[] VALUES;
        private final String localeName;
        private final GTRecipeLookup lookup;
        private final Object2IntOpenCustomHashMap<ItemStack> cache = new Object2IntOpenCustomHashMap((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount());

        private SmartFilteringMode(String localeName, GTRecipeType type) {
            this.localeName = localeName;
            this.lookup = type.getLookup();
        }

        @Override
        public String getTooltip() {
            return "cover.item_smart_filter.filtering_mode." + this.localeName;
        }

        @Override
        public IGuiTexture getIcon() {
            return new ResourceTexture("gtceu:textures/block/machines/" + this.localeName + "/overlay_front.png");
        }

        static {
            VALUES = SmartFilteringMode.values();
        }
    }
}

