/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.cover.filter;

import com.gregtechceu.gtceu.api.cover.filter.ItemFilter;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.PhantomSlotWidget;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.util.Arrays;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SimpleItemFilter
implements ItemFilter {
    protected boolean isBlackList;
    protected boolean ignoreNbt;
    protected ItemStack[] matches = new ItemStack[9];
    protected Consumer<ItemFilter> itemWriter = filter -> {};
    protected Consumer<ItemFilter> onUpdated = filter -> this.itemWriter.accept((ItemFilter)filter);
    protected int maxStackSize;

    protected SimpleItemFilter() {
        Arrays.fill(this.matches, ItemStack.f_41583_);
        this.maxStackSize = 1;
    }

    public static SimpleItemFilter loadFilter(ItemStack itemStack) {
        return SimpleItemFilter.loadFilter(itemStack.m_41784_(), filter -> itemStack.m_41751_(filter.saveFilter()));
    }

    private static SimpleItemFilter loadFilter(CompoundTag tag, Consumer<ItemFilter> itemWriter) {
        SimpleItemFilter handler = new SimpleItemFilter();
        handler.itemWriter = itemWriter;
        handler.isBlackList = tag.m_128471_("isBlackList");
        handler.ignoreNbt = tag.m_128471_("matchNbt");
        ListTag list = tag.m_128437_("matches", 10);
        for (int i = 0; i < list.size(); ++i) {
            handler.matches[i] = ItemStack.m_41712_((CompoundTag)((CompoundTag)list.get(i)));
        }
        return handler;
    }

    @Override
    public void setOnUpdated(Consumer<ItemFilter> onUpdated) {
        this.onUpdated = filter -> {
            this.itemWriter.accept((ItemFilter)filter);
            onUpdated.accept((ItemFilter)filter);
        };
    }

    @Override
    public CompoundTag saveFilter() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("isBlackList", this.isBlackList);
        tag.m_128379_("matchNbt", this.ignoreNbt);
        ListTag list = new ListTag();
        for (ItemStack match : this.matches) {
            list.add((Object)match.m_41739_(new CompoundTag()));
        }
        tag.m_128365_("matches", (Tag)list);
        return tag;
    }

    public void setBlackList(boolean blackList) {
        this.isBlackList = blackList;
        this.onUpdated.accept(this);
    }

    public void setIgnoreNbt(boolean ingoreNbt) {
        this.ignoreNbt = ingoreNbt;
        this.onUpdated.accept(this);
    }

    @Override
    public WidgetGroup openConfigurator(int x, int y) {
        WidgetGroup group = new WidgetGroup(x, y, 79, 54);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int index = i * 3 + j;
                CustomItemStackHandler handler = new CustomItemStackHandler(this.matches[index]);
                PhantomSlotWidget slot = new PhantomSlotWidget((IItemHandlerModifiable)handler, 0, i * 18, j * 18){

                    public void updateScreen() {
                        super.updateScreen();
                        this.setMaxStackSize(SimpleItemFilter.this.maxStackSize);
                    }

                    public void detectAndSendChanges() {
                        super.detectAndSendChanges();
                        this.setMaxStackSize(SimpleItemFilter.this.maxStackSize);
                    }
                };
                slot.setChangeListener(() -> {
                    this.matches[index] = handler.getStackInSlot(0);
                    this.onUpdated.accept(this);
                }).setBackground(new IGuiTexture[]{GuiTextures.SLOT});
                group.addWidget((Widget)slot);
            }
        }
        group.addWidget((Widget)new ToggleButtonWidget(59, 0, 20, 20, (IGuiTexture)GuiTextures.BUTTON_BLACKLIST, this::isBlackList, this::setBlackList));
        group.addWidget((Widget)new ToggleButtonWidget(59, 20, 20, 20, (IGuiTexture)GuiTextures.BUTTON_FILTER_NBT, this::isIgnoreNbt, this::setIgnoreNbt));
        return group;
    }

    @Override
    public boolean test(ItemStack itemStack) {
        return this.testItemCount(itemStack) > 0;
    }

    @Override
    public int testItemCount(ItemStack itemStack) {
        int totalItemCount = this.getTotalConfiguredItemCount(itemStack);
        if (this.isBlackList) {
            return totalItemCount > 0 ? 0 : Integer.MAX_VALUE;
        }
        return totalItemCount;
    }

    public int getTotalConfiguredItemCount(ItemStack itemStack) {
        int totalCount = 0;
        for (ItemStack candidate : this.matches) {
            if (this.ignoreNbt && ItemStack.m_150942_((ItemStack)candidate, (ItemStack)itemStack)) {
                totalCount += candidate.m_41613_();
                continue;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)candidate, (ItemStack)itemStack)) continue;
            totalCount += candidate.m_41613_();
        }
        return totalCount;
    }

    public void setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
        for (ItemStack match : this.matches) {
            match.m_41764_(Math.min(match.m_41613_(), maxStackSize));
        }
    }

    @Override
    public boolean isBlackList() {
        return this.isBlackList;
    }

    public boolean isIgnoreNbt() {
        return this.ignoreNbt;
    }

    public ItemStack[] getMatches() {
        return this.matches;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }
}

