/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.capability.recipe;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.gui.widget.TankWidget;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.content.SerializerFluidIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.AbstractMapIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.MapFluidIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.MapFluidTagIngredient;
import com.gregtechceu.gtceu.api.recipe.modifier.ParallelLogic;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.client.TooltipsHandler;
import com.gregtechceu.gtceu.integration.xei.entry.fluid.FluidEntryList;
import com.gregtechceu.gtceu.integration.xei.entry.fluid.FluidStackList;
import com.gregtechceu.gtceu.integration.xei.entry.fluid.FluidTagList;
import com.gregtechceu.gtceu.integration.xei.handlers.fluid.CycleFluidEntryHandler;
import com.gregtechceu.gtceu.integration.xei.widgets.GTRecipeWidget;
import com.gregtechceu.gtceu.utils.FluidKey;
import com.gregtechceu.gtceu.utils.GTHashMaps;
import com.gregtechceu.gtceu.utils.OverlayedTankHandler;
import com.gregtechceu.gtceu.utils.OverlayingFluidStorage;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public class FluidRecipeCapability
extends RecipeCapability<FluidIngredient> {
    public static final FluidRecipeCapability CAP = new FluidRecipeCapability();

    protected FluidRecipeCapability() {
        super("fluid", -12816146, true, 1, SerializerFluidIngredient.INSTANCE);
    }

    @Override
    public FluidIngredient copyInner(FluidIngredient content) {
        return content.copy();
    }

    @Override
    public FluidIngredient copyWithModifier(FluidIngredient content, ContentModifier modifier) {
        if (content.isEmpty()) {
            return content.copy();
        }
        FluidIngredient copy = content.copy();
        copy.setAmount(modifier.apply(copy.getAmount()));
        return copy;
    }

    @Override
    public List<AbstractMapIngredient> convertToMapIngredient(Object obj) {
        ObjectArrayList ingredients = new ObjectArrayList(1);
        if (obj instanceof FluidIngredient) {
            FluidIngredient ingredient = (FluidIngredient)obj;
            for (FluidIngredient.Value value : ingredient.values) {
                if (value instanceof FluidIngredient.TagValue) {
                    FluidIngredient.TagValue tagValue = (FluidIngredient.TagValue)value;
                    ingredients.add(new MapFluidTagIngredient(tagValue.getTag()));
                    continue;
                }
                Collection<Fluid> fluids = value.getFluids();
                for (Fluid fluid : fluids) {
                    ingredients.add(new MapFluidIngredient(new FluidStack(fluid, ingredient.getAmount(), ingredient.getNbt())));
                }
            }
        } else if (obj instanceof FluidStack) {
            FluidStack stack = (FluidStack)obj;
            ingredients.add(new MapFluidIngredient(stack));
            stack.getFluid().m_205069_().m_203616_().forEach(arg_0 -> FluidRecipeCapability.lambda$convertToMapIngredient$0((List)ingredients, arg_0));
        }
        return ingredients;
    }

    @Override
    public List<Object> compressIngredients(Collection<Object> ingredients) {
        ObjectArrayList list = new ObjectArrayList(ingredients.size());
        for (Object item : ingredients) {
            FluidIngredient fluidIngredient;
            boolean isEqual;
            if (item instanceof FluidIngredient) {
                FluidIngredient fluid = (FluidIngredient)item;
                isEqual = false;
                for (Object obj : list) {
                    FluidStack fluidStack;
                    if (obj instanceof FluidIngredient) {
                        fluidIngredient = (FluidIngredient)obj;
                        if (!fluid.equals(fluidIngredient)) continue;
                        isEqual = true;
                        break;
                    }
                    if (!(obj instanceof FluidStack) || !fluid.test(fluidStack = (FluidStack)obj)) continue;
                    isEqual = true;
                    break;
                }
                if (isEqual) continue;
                list.add(fluid);
                continue;
            }
            if (!(item instanceof FluidStack)) continue;
            FluidStack fluidStack = (FluidStack)item;
            isEqual = false;
            for (Object obj : list) {
                FluidStack stack;
                if (obj instanceof FluidIngredient) {
                    fluidIngredient = (FluidIngredient)obj;
                    if (!fluidIngredient.test(fluidStack)) continue;
                    isEqual = true;
                    break;
                }
                if (!(obj instanceof FluidStack) || !fluidStack.isFluidEqual(stack = (FluidStack)obj)) continue;
                isEqual = true;
                break;
            }
            if (isEqual) continue;
            list.add(fluidStack);
        }
        return list;
    }

    @Override
    public boolean isRecipeSearchFilter() {
        return true;
    }

    @Override
    public int limitParallel(GTRecipe recipe, IRecipeCapabilityHolder holder, int multiplier) {
        if (holder instanceof ICustomParallel) {
            ICustomParallel p = (ICustomParallel)((Object)holder);
            return p.limitParallel(recipe, multiplier);
        }
        int minMultiplier = 0;
        int maxMultiplier = multiplier;
        OverlayedTankHandler overlayedFluidHandler = new OverlayedTankHandler(Objects.requireNonNullElseGet((List)holder.getCapabilitiesProxy().get((Object)IO.OUT, (Object)CAP), Collections::emptyList).stream().filter(NotifiableFluidTank.class::isInstance).map(NotifiableFluidTank.class::cast).toList());
        List<FluidStack> recipeOutputs = recipe.getOutputContents(CAP).stream().map(content -> (FluidIngredient)CAP.of(content.getContent())).filter(ingredient -> !ingredient.isEmpty()).map(ingredient -> ingredient.getStacks()[0]).toList();
        while (minMultiplier != maxMultiplier) {
            overlayedFluidHandler.reset();
            int returnedAmount = 0;
            int amountToInsert = 0;
            for (FluidStack fluidStack : recipeOutputs) {
                if (fluidStack.getAmount() > 0 && !fluidStack.isEmpty() && (returnedAmount = (amountToInsert = multiplier > Integer.MAX_VALUE / fluidStack.getAmount() ? Integer.MAX_VALUE : fluidStack.getAmount() * multiplier) - overlayedFluidHandler.tryFill(fluidStack, amountToInsert)) > 0) break;
            }
            int[] bin = ParallelLogic.adjustMultiplier(returnedAmount == 0, minMultiplier, multiplier, maxMultiplier);
            minMultiplier = bin[0];
            multiplier = bin[1];
            maxMultiplier = bin[2];
        }
        return multiplier;
    }

    @Override
    public int getMaxParallelRatio(IRecipeCapabilityHolder holder, GTRecipe recipe, int parallelAmount) {
        int available;
        Map fluidStacks = (Map)Objects.requireNonNullElseGet((List)holder.getCapabilitiesProxy().get((Object)IO.IN, (Object)CAP), Collections::emptyList).stream().map(container -> container.getContents().stream().filter(FluidStack.class::isInstance).map(FluidStack.class::cast).toList()).flatMap(container -> GTHashMaps.fromFluidCollection(container).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum, Object2IntLinkedOpenHashMap::new));
        int minMultiplier = Integer.MAX_VALUE;
        HashMap<FluidIngredient, Integer> fluidCountMap = new HashMap<FluidIngredient, Integer>();
        HashMap<FluidIngredient, Integer> notConsumableMap = new HashMap<FluidIngredient, Integer>();
        for (Content content : recipe.getInputContents(CAP)) {
            FluidIngredient fluidInput = (FluidIngredient)CAP.of(content.content);
            int fluidAmount = fluidInput.getAmount();
            if (content.chance == 0) {
                notConsumableMap.computeIfPresent(fluidInput, (k, v) -> v + fluidAmount);
                notConsumableMap.putIfAbsent(fluidInput, fluidAmount);
                continue;
            }
            fluidCountMap.computeIfPresent(fluidInput, (k, v) -> v + fluidAmount);
            fluidCountMap.putIfAbsent(fluidInput, fluidAmount);
        }
        for (Map.Entry entry : notConsumableMap.entrySet()) {
            int needed = (Integer)entry.getValue();
            available = 0;
            for (Map.Entry entry2 : fluidStacks.entrySet()) {
                if (!((FluidIngredient)entry.getKey()).test(new FluidStack(((FluidKey)entry2.getKey()).fluid, ((Integer)entry2.getValue()).intValue(), ((FluidKey)entry2.getKey()).tag))) continue;
                available = (Integer)entry2.getValue();
                if (available > needed) {
                    entry2.setValue(available - needed);
                    needed -= available;
                    break;
                }
                entry2.setValue(0);
                entry.setValue(needed - available);
                needed -= available;
            }
            if (needed < available) continue;
            return 0;
        }
        if (fluidCountMap.isEmpty() && !notConsumableMap.isEmpty()) {
            return parallelAmount;
        }
        for (Map.Entry entry : fluidCountMap.entrySet()) {
            int needed = (Integer)entry.getValue();
            available = 0;
            for (Map.Entry entry3 : fluidStacks.entrySet()) {
                if (!((FluidIngredient)entry.getKey()).test(new FluidStack(((FluidKey)entry3.getKey()).fluid, ((Integer)entry3.getValue()).intValue(), ((FluidKey)entry3.getKey()).tag))) continue;
                available += ((Integer)entry3.getValue()).intValue();
            }
            if (available >= needed) {
                int ratio = (int)Math.min((float)parallelAmount, (float)available / (float)needed);
                if (ratio >= minMultiplier) continue;
                minMultiplier = ratio;
                continue;
            }
            return 0;
        }
        return minMultiplier;
    }

    @Override
    @NotNull
    public List<Object> createXEIContainerContents(List<Content> contents, GTRecipe recipe, IO io) {
        return contents.stream().map(content -> content.content).map(this::of).map(FluidRecipeCapability::mapFluid).collect(Collectors.toList());
    }

    @Override
    public Object createXEIContainer(List<?> contents) {
        return new CycleFluidEntryHandler(contents);
    }

    @Override
    @NotNull
    public Widget createWidget() {
        TankWidget tank = new TankWidget();
        tank.initTemplate();
        tank.setFillDirection(ProgressTexture.FillDirection.ALWAYS_FULL);
        return tank;
    }

    @Override
    @NotNull
    public Class<? extends Widget> getWidgetClass() {
        return TankWidget.class;
    }

    @Override
    public void applyWidgetInfo(@NotNull Widget widget, int index, boolean isXEI, IO io,  @UnknownNullability(value="null when storage == null") GTRecipeTypeUI.RecipeHolder recipeHolder, @NotNull GTRecipeType recipeType, @UnknownNullability(value="null when content == null") GTRecipe recipe, @Nullable Content content, @Nullable Object storage, int recipeTier, int chanceTier) {
        if (widget instanceof TankWidget) {
            TankWidget tank = (TankWidget)widget;
            if (storage instanceof CycleFluidEntryHandler) {
                CycleFluidEntryHandler cycleHandler = (CycleFluidEntryHandler)storage;
                tank.setFluidTank(cycleHandler, index);
            } else if (storage instanceof IFluidHandlerModifiable) {
                IFluidHandlerModifiable fluidHandler = (IFluidHandlerModifiable)storage;
                tank.setFluidTank(new OverlayingFluidStorage(fluidHandler, index));
            }
            tank.setIngredientIO(io == IO.IN ? IngredientIO.INPUT : IngredientIO.OUTPUT);
            tank.setAllowClickFilled(!isXEI);
            tank.setAllowClickDrained(!isXEI && io.support(IO.IN));
            if (isXEI) {
                tank.setShowAmount(false);
            }
            if (content != null) {
                float chance = (float)recipeType.getChanceFunction().getBoostedChance(content, recipeTier, chanceTier) / (float)content.maxChance;
                tank.setXEIChance(chance);
                tank.setOnAddedTooltips((w, tooltips) -> {
                    FluidIngredient ingredient = (FluidIngredient)CAP.of(content.content);
                    if (!isXEI && ingredient.getStacks().length > 0) {
                        FluidStack stack = ingredient.getStacks()[0];
                        TooltipsHandler.appendFluidTooltips(stack, tooltips::add, (TooltipFlag)TooltipFlag.f_256752_);
                    }
                    GTRecipeWidget.setConsumedChance(content, recipe.getChanceLogicForCapability(this, io, this.isTickSlot(index, io, recipe)), tooltips, recipeTier, chanceTier, recipeType.getChanceFunction());
                    if (this.isTickSlot(index, io, recipe)) {
                        tooltips.add(Component.m_237115_((String)"gtceu.gui.content.per_tick"));
                    }
                });
                if (io == IO.IN && content.chance == 0) {
                    tank.setIngredientIO(IngredientIO.CATALYST);
                }
            }
        }
    }

    public static FluidEntryList mapFluid(FluidIngredient ingredient) {
        int amount = ingredient.getAmount();
        CompoundTag tag = ingredient.getNbt();
        FluidTagList tags = new FluidTagList();
        FluidStackList fluids = new FluidStackList();
        for (FluidIngredient.Value value : ingredient.values) {
            if (value instanceof FluidIngredient.TagValue) {
                FluidIngredient.TagValue tagValue = (FluidIngredient.TagValue)value;
                tags.add(tagValue.getTag(), amount, ingredient.getNbt());
                continue;
            }
            fluids.addAll(value.getFluids().stream().map(fluid -> new FluidStack(fluid, amount, tag)).toList());
        }
        if (!tags.isEmpty()) {
            return tags;
        }
        return fluids;
    }

    @Override
    public Object2IntMap<FluidIngredient> makeChanceCache() {
        return super.makeChanceCache();
    }

    private static /* synthetic */ void lambda$convertToMapIngredient$0(List ingredients, TagKey tag) {
        ingredients.add(new MapFluidTagIngredient((TagKey<Fluid>)tag));
    }

    public static interface ICustomParallel {
        public int limitParallel(GTRecipe var1, int var2);
    }
}

