/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.blockentity;

import appeng.api.networking.IInWorldGridNodeHost;
import appeng.capabilities.Capabilities;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.ICleanroomReceiver;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.IDataAccessHatch;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.IEnergyInfoProvider;
import com.gregtechceu.gtceu.api.capability.ILaserContainer;
import com.gregtechceu.gtceu.api.capability.IOpticalComputationProvider;
import com.gregtechceu.gtceu.api.capability.IWorkable;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMaintenanceMachine;
import com.gregtechceu.gtceu.api.machine.trait.MachineTrait;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.misc.EnergyContainerList;
import com.gregtechceu.gtceu.api.misc.EnergyInfoProviderList;
import com.gregtechceu.gtceu.api.misc.LaserContainerList;
import com.gregtechceu.gtceu.api.pipenet.longdistance.ILDEndpoint;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.client.renderer.GTRendererProvider;
import com.gregtechceu.gtceu.common.datafixers.TagFixer;
import com.gregtechceu.gtceu.common.machine.owner.IMachineOwner;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.longdistance.LDFluidEndpointMachine;
import com.gregtechceu.gtceu.common.pipelike.item.longdistance.LDItemEndpointMachine;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.managed.MultiManagedStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaMachineBlockEntity
extends BlockEntity
implements IMachineBlockEntity {
    public final MultiManagedStorage managedStorage = new MultiManagedStorage();
    public final MetaMachine metaMachine;
    @Persisted
    private IMachineOwner owner;
    private final long offset = GTValues.RNG.m_188503_(20);

    protected MetaMachineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.metaMachine = this.getDefinition().createMetaMachine(this);
    }

    public static MetaMachineBlockEntity createBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        return new MetaMachineBlockEntity(type, pos, blockState);
    }

    public static void onBlockEntityRegister(BlockEntityType<BlockEntity> metaMachineBlockEntityBlockEntityType) {
    }

    @Override
    public MultiManagedStorage getRootStorage() {
        return this.managedStorage;
    }

    public boolean m_7531_(int id, int para) {
        if (id == 1) {
            if (this.f_58857_ != null && this.f_58857_.f_46443_) {
                this.scheduleRenderUpdate();
            }
            return true;
        }
        return false;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    public void m_7651_() {
        super.m_7651_();
        this.metaMachine.onUnload();
    }

    public void m_6339_() {
        super.m_6339_();
        this.metaMachine.onLoad();
    }

    @Override
    public boolean shouldRenderGrid(Player player, BlockPos pos, BlockState state, ItemStack held, Set<GTToolType> toolTypes) {
        return this.metaMachine.shouldRenderGrid(player, pos, state, held, toolTypes);
    }

    @Override
    public ResourceTexture sideTips(Player player, BlockPos pos, BlockState state, Set<GTToolType> toolTypes, Direction side) {
        return this.metaMachine.sideTips(player, pos, state, toolTypes, side);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        LazyOptional result = MetaMachineBlockEntity.getCapability(this.getMetaMachine(), cap, side);
        return result == null ? super.getCapability(cap, side) : result;
    }

    public void m_6596_() {
        if (this.m_58904_() != null) {
            this.m_58904_().m_151543_(this.m_58899_());
        }
    }

    @Nullable
    public static <T> LazyOptional<T> getCapability(MetaMachine machine, @NotNull Capability<T> cap, @Nullable Direction side) {
        List<Object> list;
        if (cap == GTCapability.CAPABILITY_COVERABLE) {
            return GTCapability.CAPABILITY_COVERABLE.orEmpty(cap, LazyOptional.of(machine::getCoverContainer));
        }
        if (cap == GTCapability.CAPABILITY_TOOLABLE) {
            return GTCapability.CAPABILITY_TOOLABLE.orEmpty(cap, LazyOptional.of(() -> machine));
        }
        if (cap == GTCapability.CAPABILITY_WORKABLE) {
            if (machine instanceof IWorkable) {
                IWorkable workable = (IWorkable)((Object)machine);
                return GTCapability.CAPABILITY_WORKABLE.orEmpty(cap, LazyOptional.of(() -> workable));
            }
            for (MachineTrait trait : machine.getTraits()) {
                if (!(trait instanceof IWorkable)) continue;
                IWorkable workable = (IWorkable)((Object)trait);
                return GTCapability.CAPABILITY_WORKABLE.orEmpty(cap, LazyOptional.of(() -> workable));
            }
        } else if (cap == GTCapability.CAPABILITY_CONTROLLABLE) {
            if (machine instanceof IControllable) {
                IControllable controllable = (IControllable)((Object)machine);
                return GTCapability.CAPABILITY_CONTROLLABLE.orEmpty(cap, LazyOptional.of(() -> controllable));
            }
            for (MachineTrait trait : machine.getTraits()) {
                if (!(trait instanceof IControllable)) continue;
                IControllable controllable = (IControllable)((Object)trait);
                return GTCapability.CAPABILITY_CONTROLLABLE.orEmpty(cap, LazyOptional.of(() -> controllable));
            }
        } else if (cap == GTCapability.CAPABILITY_RECIPE_LOGIC) {
            for (MachineTrait trait : machine.getTraits()) {
                if (!(trait instanceof RecipeLogic)) continue;
                RecipeLogic recipeLogic = (RecipeLogic)trait;
                return GTCapability.CAPABILITY_RECIPE_LOGIC.orEmpty(cap, LazyOptional.of(() -> recipeLogic));
            }
        } else if (cap == GTCapability.CAPABILITY_ENERGY_CONTAINER) {
            if (machine instanceof IEnergyContainer) {
                IEnergyContainer energyContainer = (IEnergyContainer)((Object)machine);
                return GTCapability.CAPABILITY_ENERGY_CONTAINER.orEmpty(cap, LazyOptional.of(() -> energyContainer));
            }
            list = MetaMachineBlockEntity.getCapabilitiesFromTraits(machine.getTraits(), side, IEnergyContainer.class);
            if (!list.isEmpty()) {
                return GTCapability.CAPABILITY_ENERGY_CONTAINER.orEmpty(cap, LazyOptional.of(() -> list.size() == 1 ? (IEnergyContainer)list.get(0) : new EnergyContainerList(list)));
            }
        } else if (cap == GTCapability.CAPABILITY_ENERGY_INFO_PROVIDER) {
            if (machine instanceof IEnergyInfoProvider) {
                IEnergyInfoProvider energyInfoProvider = (IEnergyInfoProvider)((Object)machine);
                return GTCapability.CAPABILITY_ENERGY_INFO_PROVIDER.orEmpty(cap, LazyOptional.of(() -> energyInfoProvider));
            }
            list = MetaMachineBlockEntity.getCapabilitiesFromTraits(machine.getTraits(), side, IEnergyInfoProvider.class);
            if (!list.isEmpty()) {
                return GTCapability.CAPABILITY_ENERGY_INFO_PROVIDER.orEmpty(cap, LazyOptional.of(() -> list.size() == 1 ? (IEnergyInfoProvider)list.get(0) : new EnergyInfoProviderList(list)));
            }
        } else if (cap == GTCapability.CAPABILITY_CLEANROOM_RECEIVER) {
            if (machine instanceof ICleanroomReceiver) {
                ICleanroomReceiver cleanroomReceiver = (ICleanroomReceiver)((Object)machine);
                return GTCapability.CAPABILITY_CLEANROOM_RECEIVER.orEmpty(cap, LazyOptional.of(() -> cleanroomReceiver));
            }
        } else if (cap == GTCapability.CAPABILITY_MAINTENANCE_MACHINE) {
            if (machine instanceof IMaintenanceMachine) {
                IMaintenanceMachine maintenanceMachine = (IMaintenanceMachine)((Object)machine);
                return GTCapability.CAPABILITY_MAINTENANCE_MACHINE.orEmpty(cap, LazyOptional.of(() -> maintenanceMachine));
            }
        } else if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (machine instanceof LDItemEndpointMachine) {
                LDItemEndpointMachine itemEndpointMachine = (LDItemEndpointMachine)machine;
                if (machine.getLevel().f_46443_) {
                    return null;
                }
                ILDEndpoint endpoint = itemEndpointMachine.getLink();
                if (endpoint == null) {
                    return null;
                }
                Direction outputFacing = endpoint.getOutputFacing();
                Optional h = GTTransferUtils.getAdjacentItemHandler(machine.getLevel(), endpoint.getPos(), outputFacing).map(LDItemEndpointMachine.ItemHandlerWrapper::new);
                if (h.isPresent()) {
                    return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, LazyOptional.of(h::get));
                }
            }
            if ((handler = machine.getItemHandlerCap(side, true)) != null) {
                return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, LazyOptional.of(() -> MetaMachineBlockEntity.lambda$getCapability$12((IItemHandlerModifiable)handler)));
            }
        } else if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (machine instanceof LDFluidEndpointMachine) {
                LDFluidEndpointMachine fluidEndpointMachine = (LDFluidEndpointMachine)machine;
                if (machine.getLevel().f_46443_) {
                    return null;
                }
                ILDEndpoint endpoint = fluidEndpointMachine.getLink();
                if (endpoint == null) {
                    return null;
                }
                Direction outputFacing = endpoint.getOutputFacing();
                Optional h = GTTransferUtils.getAdjacentFluidHandler(machine.getLevel(), endpoint.getPos(), outputFacing).map(LDFluidEndpointMachine.FluidHandlerWrapper::new);
                if (h.isPresent()) {
                    return ForgeCapabilities.FLUID_HANDLER.orEmpty(cap, LazyOptional.of(h::get));
                }
            }
            if ((handler = machine.getFluidHandlerCap(side, true)) != null) {
                return ForgeCapabilities.FLUID_HANDLER.orEmpty(cap, LazyOptional.of(() -> MetaMachineBlockEntity.lambda$getCapability$13((IFluidHandlerModifiable)handler)));
            }
        } else if (cap == ForgeCapabilities.ENERGY) {
            if (machine instanceof IEnergyStorage) {
                IEnergyStorage energyStorage = (IEnergyStorage)machine;
                return ForgeCapabilities.ENERGY.orEmpty(cap, LazyOptional.of(() -> energyStorage));
            }
            list = MetaMachineBlockEntity.getCapabilitiesFromTraits(machine.getTraits(), side, IEnergyStorage.class);
            if (!list.isEmpty()) {
                return ForgeCapabilities.ENERGY.orEmpty(cap, LazyOptional.of(() -> (IEnergyStorage)list.get(0)));
            }
        } else if (cap == GTCapability.CAPABILITY_LASER) {
            if (machine instanceof ILaserContainer) {
                ILaserContainer energyContainer = (ILaserContainer)((Object)machine);
                return GTCapability.CAPABILITY_LASER.orEmpty(cap, LazyOptional.of(() -> energyContainer));
            }
            list = MetaMachineBlockEntity.getCapabilitiesFromTraits(machine.getTraits(), side, ILaserContainer.class);
            if (!list.isEmpty()) {
                return GTCapability.CAPABILITY_LASER.orEmpty(cap, LazyOptional.of(() -> list.size() == 1 ? (ILaserContainer)list.get(0) : new LaserContainerList(list)));
            }
        } else if (cap == GTCapability.CAPABILITY_COMPUTATION_PROVIDER) {
            if (machine instanceof IOpticalComputationProvider) {
                IOpticalComputationProvider computationProvider = (IOpticalComputationProvider)((Object)machine);
                return GTCapability.CAPABILITY_COMPUTATION_PROVIDER.orEmpty(cap, LazyOptional.of(() -> computationProvider));
            }
            list = MetaMachineBlockEntity.getCapabilitiesFromTraits(machine.getTraits(), side, IOpticalComputationProvider.class);
            if (!list.isEmpty()) {
                return GTCapability.CAPABILITY_COMPUTATION_PROVIDER.orEmpty(cap, LazyOptional.of(() -> (IOpticalComputationProvider)list.get(0)));
            }
        } else if (cap == GTCapability.CAPABILITY_DATA_ACCESS) {
            if (machine instanceof IDataAccessHatch) {
                IDataAccessHatch computationProvider = (IDataAccessHatch)((Object)machine);
                return GTCapability.CAPABILITY_DATA_ACCESS.orEmpty(cap, LazyOptional.of(() -> computationProvider));
            }
            list = MetaMachineBlockEntity.getCapabilitiesFromTraits(machine.getTraits(), side, IDataAccessHatch.class);
            if (!list.isEmpty()) {
                return GTCapability.CAPABILITY_DATA_ACCESS.orEmpty(cap, LazyOptional.of(() -> (IDataAccessHatch)list.get(0)));
            }
        }
        if (GTCEu.Mods.isAE2Loaded() && cap == Capabilities.IN_WORLD_GRID_NODE_HOST) {
            if (machine instanceof IInWorldGridNodeHost) {
                IInWorldGridNodeHost nodeHost = (IInWorldGridNodeHost)machine;
                return Capabilities.IN_WORLD_GRID_NODE_HOST.orEmpty(cap, LazyOptional.of(() -> nodeHost));
            }
            list = MetaMachineBlockEntity.getCapabilitiesFromTraits(machine.getTraits(), side, IInWorldGridNodeHost.class);
            if (!list.isEmpty()) {
                return Capabilities.IN_WORLD_GRID_NODE_HOST.orEmpty(cap, LazyOptional.of(() -> (IInWorldGridNodeHost)list.get(0)));
            }
        }
        return null;
    }

    public static <T> List<T> getCapabilitiesFromTraits(List<MachineTrait> traits, Direction accessSide, Class<T> capability) {
        if (traits.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>();
        for (MachineTrait trait : traits) {
            if (!trait.hasCapability(accessSide) || !capability.isInstance(trait)) continue;
            list.add(capability.cast(trait));
        }
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        IRenderer renderer;
        GTRendererProvider instance = GTRendererProvider.getInstance();
        if (instance != null && (renderer = instance.getRenderer(this)) != null) {
            if (renderer.getViewDistance() == 64) {
                return new AABB(this.f_58858_.m_7918_(-1, 0, -1), this.f_58858_.m_7918_(2, 2, 2));
            }
            int viewDistHalf = renderer.getViewDistance() / 2;
            return new AABB(this.f_58858_).m_82400_((double)viewDistHalf);
        }
        return new AABB(this.f_58858_.m_7918_(-1, 0, -1), this.f_58858_.m_7918_(2, 2, 2));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.owner != null) {
            tag.m_128365_("owner", (Tag)this.owner.write());
        }
    }

    public void m_142466_(CompoundTag tag) {
        TagFixer.fixFluidTags(tag);
        super.m_142466_(tag);
        if (tag.m_128441_("owner")) {
            this.owner = IMachineOwner.create(tag.m_128469_("owner"));
        }
    }

    @Override
    public MetaMachine getMetaMachine() {
        return this.metaMachine;
    }

    @Override
    public void setOwner(IMachineOwner owner) {
        this.owner = owner;
    }

    @Override
    public IMachineOwner getOwner() {
        return this.owner;
    }

    private static /* synthetic */ IFluidHandler lambda$getCapability$13(IFluidHandlerModifiable handler) {
        return handler;
    }

    private static /* synthetic */ IItemHandler lambda$getCapability$12(IItemHandlerModifiable handler) {
        return handler;
    }
}

