/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.client.ClientProxy;
import com.gregtechceu.gtceu.common.CommonProxy;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import dev.emi.emi.config.EmiConfig;
import java.nio.file.Path;
import me.shedaniel.rei.api.client.REIRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="gtceu")
public class GTCEu {
    public static final String MOD_ID = "gtceu";
    public static final String NAME = "GregTechCEu";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"GregTechCEu");

    public GTCEu() {
        GTCEu.init();
        GTCEuAPI.instance = this;
        DistExecutor.unsafeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    }

    public static void init() {
        LOGGER.info("{} is initializing...", (Object)NAME);
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, FormattingUtil.toLowerCaseUnder(path));
    }

    public static String appendIdString(String id) {
        return id.indexOf(58) == -1 ? "gtceu:" + id : id;
    }

    public static ResourceLocation appendId(String id) {
        String[] strings = new String[]{MOD_ID, id};
        int i = id.indexOf(58);
        if (i >= 0) {
            strings[1] = id.substring(i + 1);
            if (i >= 1) {
                strings[0] = id.substring(0, i);
            }
        }
        return new ResourceLocation(strings[0], strings[1]);
    }

    public static boolean isProd() {
        return FMLLoader.isProduction();
    }

    public static boolean isDev() {
        return !GTCEu.isProd();
    }

    public static boolean isDataGen() {
        return FMLLoader.getLaunchHandler().isData();
    }

    public static MinecraftServer getMinecraftServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static boolean isClientThread() {
        return GTCEu.isClientSide() && Minecraft.m_91087_().m_18695_();
    }

    public static boolean isClientSide() {
        return FMLEnvironment.dist.isClient();
    }

    public static boolean canGetServerLevel() {
        if (GTCEu.isClientSide()) {
            return Minecraft.m_91087_().f_91073_ != null;
        }
        MinecraftServer server = GTCEu.getMinecraftServer();
        return server != null && !server.m_129918_() && !server.m_129782_() && server.m_130010_() && !server.m_195518_();
    }

    public static Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    public static class Mods {
        public static boolean isJEILoaded() {
            return !GTCEu.isModLoaded("emi") && !GTCEu.isModLoaded("roughlyenoughitems") && GTCEu.isModLoaded("jei");
        }

        public static boolean isREILoaded() {
            return GTCEu.isModLoaded("roughlyenoughitems") && (!GTCEu.isClientSide() || REIRuntime.getInstance().isOverlayVisible());
        }

        public static boolean isEMILoaded() {
            return GTCEu.isModLoaded("emi") && (!GTCEu.isClientSide() || EmiConfig.enabled);
        }

        public static boolean isKubeJSLoaded() {
            return GTCEu.isModLoaded("kubejs");
        }

        public static boolean isIrisOculusLoaded() {
            return GTCEu.isModLoaded("iris") || GTCEu.isModLoaded("oculus");
        }

        public static boolean isSodiumRubidiumEmbeddiumLoaded() {
            return GTCEu.isModLoaded("sodium") || GTCEu.isModLoaded("rubidium") || GTCEu.isModLoaded("embeddium");
        }

        public static boolean isAE2Loaded() {
            return GTCEu.isModLoaded("ae2");
        }

        public static boolean isCuriosLoaded() {
            return GTCEu.isModLoaded("curios");
        }

        public static boolean isShimmerLoaded() {
            return GTCEu.isModLoaded("shimmer");
        }

        public static boolean isJAVDLoaded() {
            return GTCEu.isModLoaded("javd");
        }

        public static boolean isFTBTeamsLoaded() {
            return GTCEu.isModLoaded("ftbteams");
        }

        public static boolean isArgonautsLoaded() {
            return GTCEu.isModLoaded("argonauts");
        }
    }
}

