/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.ErrorReporter;
import dev.latvian.mods.rhino.EvaluatorException;
import dev.latvian.mods.rhino.ScriptRuntime;

class DefaultErrorReporter
implements ErrorReporter {
    static final DefaultErrorReporter instance = new DefaultErrorReporter();
    private boolean forEval;
    private ErrorReporter chainedReporter;

    static ErrorReporter forEval(ErrorReporter reporter) {
        DefaultErrorReporter r = new DefaultErrorReporter();
        r.forEval = true;
        r.chainedReporter = reporter;
        return r;
    }

    private DefaultErrorReporter() {
    }

    @Override
    public void warning(String message, String sourceURI, int line, String lineText, int lineOffset) {
        if (this.chainedReporter != null) {
            this.chainedReporter.warning(message, sourceURI, line, lineText, lineOffset);
        }
    }

    @Override
    public void error(Context cx, String message, String sourceURI, int line, String lineText, int lineOffset) {
        if (this.forEval) {
            String error = "SyntaxError";
            String TYPE_ERROR_NAME = "TypeError";
            String DELIMETER = ": ";
            String prefix = "TypeError: ";
            if (message.startsWith("TypeError: ")) {
                error = "TypeError";
                message = message.substring("TypeError: ".length());
            }
            throw ScriptRuntime.constructError(cx, error, message, sourceURI, line, lineText, lineOffset);
        }
        if (this.chainedReporter == null) {
            throw this.runtimeError(cx, message, sourceURI, line, lineText, lineOffset);
        }
        this.chainedReporter.error(cx, message, sourceURI, line, lineText, lineOffset);
    }

    @Override
    public EvaluatorException runtimeError(Context cx, String message, String sourceURI, int line, String lineText, int lineOffset) {
        if (this.chainedReporter != null) {
            return this.chainedReporter.runtimeError(cx, message, sourceURI, line, lineText, lineOffset);
        }
        return new EvaluatorException(cx, message, sourceURI, line, lineText, lineOffset);
    }
}

