/*
 * Decompiled with CFR 0.152.
 */
package de.castcrafter.travelanchors.network;

import de.castcrafter.travelanchors.TravelAnchorList;
import de.castcrafter.travelanchors.network.AnchorListUpdateMessage;
import de.castcrafter.travelanchors.network.AnchorLockMessage;
import de.castcrafter.travelanchors.network.AnchorNameChangeMessage;
import de.castcrafter.travelanchors.network.ClientEventMessage;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.network.NetworkX;

public class Networking
extends NetworkX {
    public Networking(ModX mod) {
        super(mod);
    }

    protected NetworkX.Protocol getProtocol() {
        return NetworkX.Protocol.of((String)"6");
    }

    protected void registerPackets() {
        this.registerGame(NetworkDirection.PLAY_TO_SERVER, new AnchorNameChangeMessage.Serializer(), () -> AnchorNameChangeMessage.Handler::new);
        this.registerGame(NetworkDirection.PLAY_TO_SERVER, new AnchorLockMessage.Serializer(), () -> AnchorLockMessage.Handler::new);
        this.registerGame(NetworkDirection.PLAY_TO_CLIENT, new AnchorListUpdateMessage.Serializer(), () -> AnchorListUpdateMessage.Handler::new);
        this.registerGame(NetworkDirection.PLAY_TO_SERVER, new ClientEventMessage.Serializer(), () -> ClientEventMessage.Handler::new);
    }

    public void sendNameChange(Level level, BlockPos pos, String name) {
        if (level.f_46443_) {
            this.channel.sendToServer((Object)new AnchorNameChangeMessage(pos, name));
        }
    }

    public void sendLock(Level level, BlockPos pos) {
        if (level.f_46443_) {
            this.channel.sendToServer((Object)new AnchorLockMessage(pos));
        }
    }

    public void updateTravelAnchorList(Level level, @Nullable TravelAnchorList list) {
        if (!level.f_46443_) {
            if (list == null) {
                list = TravelAnchorList.get(level);
            }
            this.channel.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new AnchorListUpdateMessage(list.m_7176_(new CompoundTag())));
        }
    }

    public void updateTravelAnchorList(Player player) {
        if (!player.m_20193_().f_46443_ && player instanceof ServerPlayer) {
            this.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new AnchorListUpdateMessage(TravelAnchorList.get(player.m_20193_()).m_7176_(new CompoundTag())));
        }
    }

    public void sendClientEventToServer(Level level, ClientEventMessage.Type type) {
        if (level.f_46443_) {
            this.channel.sendToServer((Object)new ClientEventMessage(type));
        }
    }
}

