/*
 * Decompiled with CFR 0.152.
 */
package de.castcrafter.travelanchors;

import de.castcrafter.travelanchors.TeleportHandler;
import de.castcrafter.travelanchors.TravelAnchors;
import de.castcrafter.travelanchors.config.ClientConfig;
import de.castcrafter.travelanchors.network.ClientEventMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.moddingx.libx.event.InteractBlockEmptyHandEvent;

public class EventListener {
    @SubscribeEvent
    public void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        TravelAnchors.getNetwork().updateTravelAnchorList(event.getEntity());
    }

    @SubscribeEvent
    public void playerChangeDim(PlayerEvent.PlayerChangedDimensionEvent event) {
        TravelAnchors.getNetwork().updateTravelAnchorList(event.getEntity());
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickItem event) {
        Level level = event.getLevel();
        Player player = event.getEntity();
        if (TeleportHandler.canPlayerTeleport(player, event.getHand()) && !event.getItemStack().m_41619_()) {
            if (player.m_6144_() && TeleportHandler.canItemTeleport(player, event.getHand())) {
                if (TeleportHandler.shortTeleport(level, player, event.getHand())) {
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.m_19078_((boolean)event.getLevel().f_46443_));
                    player.m_36335_().m_41524_(event.getItemStack().m_41720_(), 30);
                }
            } else if (TeleportHandler.anchorTeleport(level, player, player.m_20183_().m_7949_().m_7495_(), event.getHand())) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.m_19078_((boolean)event.getLevel().f_46443_));
            }
        }
    }

    @SubscribeEvent
    public void onEmptyClick(PlayerInteractEvent.RightClickEmpty event) {
        Level level = event.getLevel();
        Player player = event.getEntity();
        if (TeleportHandler.canBlockTeleport(player) && !player.m_6144_() && event.getHand() == InteractionHand.MAIN_HAND && event.getEntity().m_21120_(InteractionHand.OFF_HAND).m_41619_() && event.getItemStack().m_41619_()) {
            TravelAnchors.getNetwork().sendClientEventToServer(level, ClientEventMessage.Type.EMPTY_HAND_INTERACT);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public void emptyBlockClick(InteractBlockEmptyHandEvent event) {
        if (event.getHand() == InteractionHand.MAIN_HAND && TeleportHandler.canPlayerTeleport((Player)event.getPlayer(), event.getHand()) && !event.getPlayer().m_6144_() && TeleportHandler.anchorTeleport(event.getLevel(), (Player)event.getPlayer(), event.getPlayer().m_20183_().m_7949_().m_7495_(), event.getHand())) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (ClientConfig.disable_elevation) {
                if (TeleportHandler.canBlockTeleport(player) && !player.m_6144_()) {
                    TravelAnchors.getNetwork().sendClientEventToServer(player.m_20193_(), ClientEventMessage.Type.JUMP_TP);
                }
            } else if (TeleportHandler.canElevate(player) && !player.m_6144_()) {
                TravelAnchors.getNetwork().sendClientEventToServer(player.m_20193_(), ClientEventMessage.Type.JUMP);
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onSneak(MovementInputUpdateEvent event) {
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91066_.f_92090_.m_90859_() && !ClientConfig.disable_elevation && TeleportHandler.canElevate((Player)Minecraft.m_91087_().f_91074_)) {
            TravelAnchors.getNetwork().sendClientEventToServer(Minecraft.m_91087_().f_91074_.m_20193_(), ClientEventMessage.Type.SNEAK);
        }
    }
}

