/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelio.lib.nbt;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.UUID;
import net.creeperhost.ftbbackups.repack.net.covers1624.quack.util.SneakyUtils;
import net.creeperhost.levelio.lib.nbt.ICompoundTag;
import net.creeperhost.levelio.lib.nbt.IListTag;
import net.creeperhost.levelio.lib.nbt.ITag;
import net.creeperhost.levelio.lib.nbt.NBTHandler;
import net.querz.nbt.io.NBTInputStream;
import net.querz.nbt.io.NBTUtil;
import net.querz.nbt.io.SNBTUtil;
import net.querz.nbt.tag.CompoundTag;
import net.querz.nbt.tag.DoubleTag;
import net.querz.nbt.tag.FloatTag;
import net.querz.nbt.tag.IntArrayTag;
import net.querz.nbt.tag.IntTag;
import net.querz.nbt.tag.ListTag;
import net.querz.nbt.tag.LongArrayTag;
import net.querz.nbt.tag.ShortTag;
import net.querz.nbt.tag.StringTag;
import net.querz.nbt.tag.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuerzNBTImpl
implements NBTHandler {
    @Override
    @Nullable
    public ICompoundTag read(Path path) throws IOException {
        Tag tag = NBTUtil.read((File)path.toFile()).getTag();
        return tag instanceof CompoundTag ? new CompoundWrapper((CompoundTag)tag) : null;
    }

    @Override
    @Nullable
    public ICompoundTag read(InputStream is) throws IOException {
        Tag tag = new NBTInputStream(is).readTag(512).getTag();
        return tag instanceof CompoundTag ? new CompoundWrapper((CompoundTag)tag) : null;
    }

    @Override
    @Nullable
    public ICompoundTag fromSNBT(String snbt) throws IOException {
        Tag tag = SNBTUtil.fromSNBT((String)snbt, (boolean)false);
        return tag instanceof CompoundTag ? new CompoundWrapper((CompoundTag)tag) : null;
    }

    @Override
    public void write(ICompoundTag tag, Path path) throws IOException {
        NBTUtil.write((Tag)((CompoundWrapper)tag).tag, (File)path.toFile());
    }

    @Override
    public ICompoundTag emptyCompound() {
        return new CompoundWrapper(new CompoundTag());
    }

    public static class ListWrapper
    implements IListTag {
        private final ListTag<?> tag;

        public ListWrapper(ListTag<?> tag) {
            this.tag = tag;
        }

        @Override
        public void remove(int index) {
            this.tag.remove(index);
        }

        @Override
        public boolean isEmpty() {
            return this.tag.size() == 0;
        }

        @Override
        public ICompoundTag getCompound(int index) {
            Tag obj = this.tag.get(index);
            if (obj instanceof CompoundTag) {
                return new CompoundWrapper((CompoundTag)obj);
            }
            return new CompoundWrapper(new CompoundTag());
        }

        @Override
        @Nullable
        public IListTag getList(int index) {
            Tag obj = this.tag.get(index);
            if (obj instanceof ListTag) {
                return new ListWrapper((ListTag)obj);
            }
            return null;
        }

        @Override
        public short getShort(int index) {
            Tag t = this.tag.get(index);
            return t instanceof ShortTag ? ((ShortTag)t).asShort() : (short)0;
        }

        @Override
        public int getInt(int index) {
            Tag t = this.tag.get(index);
            return t instanceof IntTag ? ((IntTag)t).asInt() : 0;
        }

        @Override
        public int[] getIntArray(int index) {
            Tag t = this.tag.get(index);
            return t instanceof IntArrayTag ? (int[])((IntArrayTag)t).getValue() : new int[]{};
        }

        @Override
        public long[] getLongArray(int index) {
            Tag t = this.tag.get(index);
            return t instanceof LongArrayTag ? (long[])((LongArrayTag)t).getValue() : new long[]{};
        }

        @Override
        public double getDouble(int index) {
            Tag t = this.tag.get(index);
            return t instanceof DoubleTag ? ((DoubleTag)t).asDouble() : 0.0;
        }

        @Override
        public float getFloat(int index) {
            Tag t = this.tag.get(index);
            return t instanceof FloatTag ? ((FloatTag)t).asFloat() : 0.0f;
        }

        @Override
        public String getString(int index) {
            Tag t = this.tag.get(index);
            return t instanceof StringTag ? ((StringTag)t).getValue() : "";
        }

        @Override
        public int size() {
            return this.tag.size();
        }

        @Override
        public void set(int index, ITag tag) {
            this.tag.set(index, (Tag)SneakyUtils.unsafeCast(tag.unwrap()));
        }

        @Override
        public void add(ITag tag) {
            this.tag.add((Tag)SneakyUtils.unsafeCast(tag.unwrap()));
        }

        public ListTag<?> unwrap() {
            return this.tag;
        }
    }

    public static class CompoundWrapper
    implements ICompoundTag {
        private final CompoundTag tag;

        public CompoundWrapper(CompoundTag tag) {
            this.tag = tag;
        }

        @Override
        public void put(String name, ITag value) {
            this.tag.put(name, (Tag)value.unwrap());
        }

        @Override
        public void putByte(String name, byte value) {
            this.tag.putByte(name, value);
        }

        @Override
        public void putShort(String name, short value) {
            this.tag.putShort(name, value);
        }

        @Override
        public void putInt(String name, int value) {
            this.tag.putInt(name, value);
        }

        @Override
        public void putLong(String name, long value) {
            this.tag.putLong(name, value);
        }

        @Override
        public void putUUID(String name, UUID value) {
            this.tag.putIntArray(name, CompoundWrapper.uuidToIntArray(value));
        }

        private static int[] uuidToIntArray(UUID uuid) {
            long most = uuid.getMostSignificantBits();
            long least = uuid.getLeastSignificantBits();
            return CompoundWrapper.leastMostToIntArray(most, least);
        }

        private static int[] leastMostToIntArray(long most, long least) {
            return new int[]{(int)(most >> 32), (int)most, (int)(least >> 32), (int)least};
        }

        private static UUID uuidFromIntArray(int[] uuidInts) {
            return new UUID((long)uuidInts[0] << 32 | (long)uuidInts[1] & 0xFFFFFFFFL, (long)uuidInts[2] << 32 | (long)uuidInts[3] & 0xFFFFFFFFL);
        }

        @Override
        public UUID getUUID(String name) {
            int[] ints = this.tag.getIntArray(name);
            if (ints != null && ints.length == 4) {
                return CompoundWrapper.uuidFromIntArray(ints);
            }
            throw new IllegalArgumentException("Invalid UUID tag, Expected int array of length 4, found " + ints);
        }

        @Override
        public boolean hasUUID(String name) {
            int[] ints = this.tag.getIntArray(name);
            return ints != null && ints.length == 4;
        }

        @Override
        public void putFloat(String name, float value) {
            this.tag.putFloat(name, value);
        }

        @Override
        public void putDouble(String name, double value) {
            this.tag.putDouble(name, value);
        }

        @Override
        public void putString(String name, String value) {
            this.tag.putString(name, value);
        }

        @Override
        public void putByteArray(String name, byte[] value) {
            this.tag.putByteArray(name, value);
        }

        @Override
        public void putIntArray(String name, int[] value) {
            this.tag.putIntArray(name, value);
        }

        @Override
        public void putLongArray(String name, long[] value) {
            this.tag.putLongArray(name, value);
        }

        @Override
        public void putBoolean(String name, boolean value) {
            this.tag.putBoolean(name, value);
        }

        @Override
        public byte getTagType(String name) {
            Tag tag = this.tag.get(name);
            return tag == null ? (byte)0 : tag.getID();
        }

        @Override
        public boolean contains(String name) {
            return this.tag.containsKey(name);
        }

        @Override
        public boolean contains(String name, int type) {
            Tag tag = this.tag.get(name);
            return tag != null && tag.getID() == type;
        }

        @Override
        public byte getByte(String name) {
            return this.tag.getByte(name);
        }

        @Override
        public short getShort(String name) {
            return this.tag.getShort(name);
        }

        @Override
        public int getInt(String name) {
            return this.tag.getInt(name);
        }

        @Override
        public long getLong(String name) {
            return this.tag.getLong(name);
        }

        @Override
        public float getFloat(String name) {
            return this.tag.getFloat(name);
        }

        @Override
        public double getDouble(String name) {
            return this.tag.getDouble(name);
        }

        @Override
        @NotNull
        public String getString(String name) {
            return this.tag.getString(name);
        }

        @Override
        public byte[] getByteArray(String name) {
            return this.tag.getByteArray(name);
        }

        @Override
        public int[] getIntArray(String name) {
            return this.tag.getIntArray(name);
        }

        @Override
        public long[] getLongArray(String name) {
            return this.tag.getLongArray(name);
        }

        @Override
        @NotNull
        public ICompoundTag getCompound(String name) {
            CompoundTag tag = this.tag.getCompoundTag(name);
            return new CompoundWrapper(tag == null ? new CompoundTag() : tag);
        }

        @Override
        public IListTag getList(String name, int type) {
            ListTag list = this.tag.getListTag(name);
            return list == null ? null : new ListWrapper(list);
        }

        @Override
        public boolean getBoolean(String name) {
            return this.tag.getBoolean(name);
        }

        @Override
        public void remove(String name) {
            this.tag.remove(name);
        }

        public CompoundTag unwrap() {
            return this.tag;
        }

        public int hashCode() {
            return this.tag.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof CompoundTag) {
                return this.tag.equals(obj);
            }
            if (obj instanceof CompoundWrapper) {
                return this.tag.equals((Object)((CompoundWrapper)obj).tag);
            }
            return super.equals(obj);
        }
    }
}

