/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelio.lib;

import java.util.Arrays;
import net.creeperhost.levelio.data.Section;

public class SectionStorage {
    private Section[] sections = new Section[1];
    private int minSection = 0;
    private int maxSection = 0;

    public void add(Section section) {
        int y = section.getY();
        this.ensureCapacity(y);
        this.sections[y - this.minSection] = section;
    }

    private void ensureCapacity(int y) {
        if (y < this.minSection) {
            int newCap = this.maxSection - y + 1;
            int oldCap = this.sections.length;
            this.sections = Arrays.copyOf(this.sections, newCap);
            System.arraycopy(this.sections, 0, this.sections, this.minSection - y, oldCap);
            this.minSection = y;
        } else if (y > this.maxSection) {
            int newCap = y - this.minSection + 1;
            this.sections = Arrays.copyOf(this.sections, newCap);
            this.maxSection = y;
        }
    }

    public Section get(int sectionIndex) {
        int i = sectionIndex - this.minSection;
        if (i < 0 || i >= this.sections.length) {
            return null;
        }
        return this.sections[i];
    }
}

