/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.findme.client;

import java.util.Iterator;
import java.util.LinkedList;

public class ClientTickHandler {
    private static final Lock lock = new Lock();
    private static boolean ticking = false;
    private static LinkedList<QueueEntry> queue = new LinkedList();
    private static LinkedList<WaitEntry> waitlist = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clientTick() {
        ticking = true;
        Lock lock = ClientTickHandler.lock;
        synchronized (lock) {
            ticking = true;
            Iterator iterator = queue.iterator();
            while (iterator.hasNext()) {
                QueueEntry entry = (QueueEntry)iterator.next();
                if (entry.counter-- > 0) continue;
                entry.runnable.run();
                iterator.remove();
            }
            ticking = false;
            for (WaitEntry entry : waitlist) {
                queue.addLast(new QueueEntry(entry.runnable, entry.delay));
            }
        }
        waitlist.clear();
    }

    public static void addRunnable(Runnable runnable) {
        ClientTickHandler.addRunnable(runnable, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRunnable(Runnable runnable, int delay) {
        Lock lock = ClientTickHandler.lock;
        synchronized (lock) {
            if (ticking) {
                waitlist.addLast(new WaitEntry(runnable, delay));
            } else {
                queue.addLast(new QueueEntry(runnable, delay));
            }
        }
    }

    private static class Lock {
        private Lock() {
        }
    }

    private static class QueueEntry {
        public Runnable runnable;
        public int counter;

        public QueueEntry(Runnable runnable, int counter) {
            this.runnable = runnable;
            this.counter = counter;
        }
    }

    private static class WaitEntry {
        public Runnable runnable;
        public int delay;

        public WaitEntry(Runnable runnable, int delay) {
            this.runnable = runnable;
            this.delay = delay;
        }
    }
}

