/*
 * Decompiled with CFR 0.152.
 */
package malte0811.ferritecore.fastmap;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Reference2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import malte0811.ferritecore.fastmap.BinaryFastMapKey;
import malte0811.ferritecore.fastmap.CompactFastMapKey;
import malte0811.ferritecore.fastmap.FastMapKey;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class FastMap<Value> {
    private static final int INVALID_INDEX = -1;
    private final List<FastMapKey<?>> keys;
    private final List<Value> valueMatrix;
    private final Reference2IntMap<Property<?>> toKeyIndex;
    private final ReferenceSet<Property<?>> propertySet;

    public FastMap(Collection<Property<?>> properties, Map<Map<Property<?>, Comparable<?>>, Value> valuesMap, boolean compact) {
        ArrayList<FastMapKey> keys = new ArrayList<FastMapKey>(properties.size());
        int factorUpTo = 1;
        this.toKeyIndex = FastMap.useArrayMapForSize(properties.size()) ? new Reference2IntArrayMap() : new Reference2IntOpenHashMap();
        this.toKeyIndex.defaultReturnValue(-1);
        for (Property<?> prop : properties) {
            this.toKeyIndex.put(prop, keys.size());
            FastMapKey nextKey = compact ? new CompactFastMapKey(prop, factorUpTo) : new BinaryFastMapKey(prop, factorUpTo);
            keys.add(nextKey);
            factorUpTo *= nextKey.getFactorToNext();
        }
        this.keys = ImmutableList.copyOf(keys);
        ArrayList<Value> valuesList = new ArrayList<Value>(factorUpTo);
        for (int i = 0; i < factorUpTo; ++i) {
            valuesList.add(null);
        }
        for (Map.Entry<Map<Property<?>, Comparable<?>>, Value> state : valuesMap.entrySet()) {
            valuesList.set(this.getIndexOf(state.getKey()), state.getValue());
        }
        this.valueMatrix = Collections.unmodifiableList(valuesList);
        this.propertySet = FastMap.useArrayMapForSize(properties.size()) ? new ReferenceArraySet(properties) : new ReferenceLinkedOpenHashSet(properties);
    }

    @Nullable
    public Value with(int oldIndex, Property<?> prop, Object value) {
        if (!(value instanceof Comparable)) {
            return null;
        }
        Comparable valueComparable = (Comparable)value;
        FastMapKey<?> keyToChange = this.getKeyFor(prop);
        if (keyToChange == null) {
            return null;
        }
        int newIndex = keyToChange.replaceIn(oldIndex, valueComparable);
        if (newIndex < 0) {
            return null;
        }
        return this.valueMatrix.get(newIndex);
    }

    public int getIndexOf(Map<Property<?>, Comparable<?>> state) {
        int id = 0;
        for (FastMapKey<?> k : this.keys) {
            id += k.toPartialMapIndex(state.get(k.getProperty()));
        }
        return id;
    }

    @Nullable
    public <T extends Comparable<T>> T getValue(int stateIndex, Property<T> property) {
        FastMapKey<T> propId = this.getKeyFor(property);
        if (propId == null) {
            return null;
        }
        return propId.getValue(stateIndex);
    }

    @Nullable
    public Comparable<?> getValue(int stateIndex, Object key) {
        if (key instanceof Property) {
            return this.getValue(stateIndex, (Property)key);
        }
        return null;
    }

    public Map.Entry<Property<?>, Comparable<?>> getEntry(int propertyIndex, int stateIndex) {
        return new AbstractMap.SimpleImmutableEntry(this.getKey(propertyIndex).getProperty(), (Comparable<?>)this.getKey(propertyIndex).getValue(stateIndex));
    }

    public int numProperties() {
        return this.keys.size();
    }

    public FastMapKey<?> getKey(int keyIndex) {
        return this.keys.get(keyIndex);
    }

    @Nullable
    private <T extends Comparable<T>> FastMapKey<T> getKeyFor(Property<T> prop) {
        int index = this.toKeyIndex.getInt(prop);
        if (index == -1) {
            return null;
        }
        return this.getKey(index);
    }

    public boolean isSingleState() {
        return this.valueMatrix.size() == 1;
    }

    public ReferenceSet<Property<?>> getPropertySet() {
        return this.propertySet;
    }

    private static boolean useArrayMapForSize(int numElements) {
        return numElements < 5;
    }
}

