/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.util;

import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.confluence.mod.common.component.RepeaterContents;
import org.confluence.mod.common.item.crossbow.BaseTerraRepeaterItem;
import org.jetbrains.annotations.NotNull;

public class RepeaterContentsComponentHandler
implements IItemHandlerModifiable {
    protected final MutableDataComponentHolder parent;
    protected final DataComponentType<RepeaterContents> component;
    protected final int capacity;

    public RepeaterContentsComponentHandler(MutableDataComponentHolder parent, DataComponentType<RepeaterContents> component, int capacity) {
        this.parent = parent;
        this.component = component;
        this.capacity = capacity;
    }

    public static boolean insertItem(ItemStack weapon, ItemStack stack, boolean isInfiniteResources) {
        return RepeaterContentsComponentHandler.insertItem(weapon, () -> stack, isInfiniteResources);
    }

    public static boolean insertItem(ItemStack weapon, Supplier<ItemStack> stackConsumer, boolean isInfiniteResources) {
        return RepeaterContentsComponentHandler.insertItem(weapon, stackConsumer, (originalStack, remainingAfterInsert) -> originalStack.setCount(remainingAfterInsert.getCount()), isInfiniteResources);
    }

    public static boolean insertItem(ItemStack weapon, Supplier<ItemStack> stackConsumer, BiConsumer<ItemStack, ItemStack> operation, boolean isInfiniteResources) {
        Object object = weapon.getCapability(Capabilities.ItemHandler.ITEM);
        if (!(object instanceof RepeaterContentsComponentHandler)) {
            return false;
        }
        RepeaterContentsComponentHandler handler = (RepeaterContentsComponentHandler)object;
        return handler.insertItem(stackConsumer, operation, isInfiniteResources);
    }

    public boolean insertItem(Supplier<ItemStack> stackConsumer, boolean isInfiniteResources) {
        return this.insertItem(stackConsumer, (ItemStack originalStack, ItemStack remainingAfterInsert) -> originalStack.setCount(remainingAfterInsert.getCount()), isInfiniteResources);
    }

    public boolean insertItem(Supplier<ItemStack> stackConsumer, BiConsumer<ItemStack, ItemStack> operation, boolean isInfiniteResources) {
        int itemsInserted = 0;
        int i = 0;
        ItemStack originalStack = null;
        block0: while (!this.getContents().isFull() && i < 2) {
            ItemStack currentStack = stackConsumer.get();
            if (originalStack != null && originalStack == currentStack) {
                ++i;
            } else {
                originalStack = currentStack;
            }
            if (originalStack.isEmpty() || !this.isItemValid(originalStack)) break;
            for (int j = 0; j < this.getSlots(); ++j) {
                ItemStack stackToInsert;
                ItemStack itemStack = stackToInsert = isInfiniteResources ? originalStack.copy() : originalStack;
                if (isInfiniteResources) {
                    stackToInsert.setCount(stackToInsert.getMaxStackSize());
                }
                if (!this.isItemValid(j, stackToInsert)) continue;
                ItemStack remainingAfterInsert = this.insertItem(j, stackToInsert, false);
                ItemStack itemStack2 = this.getStackInSlot(j);
                if (remainingAfterInsert == stackToInsert) {
                    if (!itemStack2.isEmpty()) continue;
                    continue block0;
                }
                if (!isInfiniteResources) {
                    operation.accept(stackToInsert, remainingAfterInsert);
                }
                ++itemsInserted;
                if (remainingAfterInsert.isEmpty()) continue block0;
            }
        }
        return itemsInserted > 0;
    }

    public static List<ItemStack> extractItemList(ItemStack weapon, int amount, boolean isSimulate) {
        RepeaterContentsComponentHandler handler;
        NonNullList result = NonNullList.create();
        Object object = weapon.getCapability(Capabilities.ItemHandler.ITEM);
        if (!(object instanceof RepeaterContentsComponentHandler) || (handler = (RepeaterContentsComponentHandler)object).getContents().isEmpty()) {
            return result;
        }
        int j = 0;
        int slots = handler.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack insertedItem = handler.extractItem(i, amount - j, isSimulate);
            if (insertedItem.isEmpty()) continue;
            result.add(insertedItem);
            if ((j += insertedItem.getCount()) >= amount) break;
        }
        return result;
    }

    public Iterator<ItemStack> getAllItemIterator() {
        return this.getContents().nonEmptyItemsCopy().iterator();
    }

    public boolean isEmpty() {
        return this.getContents().isEmpty();
    }

    public int getSlots() {
        return this.getContents().stream().toList().size();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.getStackFromContents(this.getContents(), slot);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        if (!this.isItemValid(slot, stack)) {
            throw new RuntimeException("Invalid stack " + String.valueOf(stack) + " for slot " + slot + ")");
        }
        RepeaterContents contents = this.getContents();
        ItemStack existing = this.getStackFromContents(contents, slot);
        if (!ItemStack.matches((ItemStack)stack, (ItemStack)existing)) {
            this.updateContents(contents, stack, slot);
        }
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack toInsert, boolean simulate) {
        ItemStack stack;
        int maxInsertLimit;
        this.validateSlotIndex(slot);
        if (toInsert.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (!this.isItemValid(slot, toInsert)) {
            return toInsert;
        }
        RepeaterContents contents = this.getContents();
        ItemStack existing = this.getStackFromContents(contents, slot);
        int n = maxInsertLimit = existing.isEmpty() ? Math.min(contents.getMaxItemCapacity() - contents.getItemsTotalCount(), toInsert.getCount()) : Math.min(this.getSlotLimit(slot), toInsert.getMaxStackSize());
        if (!existing.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)toInsert, (ItemStack)existing)) {
            return toInsert;
        }
        if (maxInsertLimit <= 0) {
            return toInsert;
        }
        int inserted = Math.min(maxInsertLimit, toInsert.getCount());
        if (!simulate) {
            this.updateContents(contents, toInsert.copyWithCount(existing.getCount() + inserted), slot);
        }
        return (stack = toInsert.copyWithCount(toInsert.getCount() - inserted)).isEmpty() ? ItemStack.EMPTY : stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        this.validateSlotIndex(slot);
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        RepeaterContents contents = this.getContents();
        ItemStack existing = this.getStackFromContents(contents, slot);
        if (existing.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int toExtract = Math.min(amount, existing.getCount());
        if (!simulate) {
            this.updateContents(contents, existing.copyWithCount(existing.getCount() - toExtract), slot);
        }
        return existing.copyWithCount(toExtract);
    }

    public int getSlotLimit(int slot) {
        RepeaterContents contents = this.getContents();
        return Math.max(0, Math.min(this.getStackInSlot(slot).getMaxStackSize(), contents.getMaxItemCapacity() - contents.getItemsTotalCount()));
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.isItemValid(stack);
    }

    public boolean isItemValid(@NotNull ItemStack stack) {
        BaseTerraRepeaterItem repeaterItem;
        ItemStack itemStack;
        Supplier<Boolean> is = () -> !this.getContents().isFull() && stack.canFitInsideContainerItems();
        MutableDataComponentHolder mutableDataComponentHolder = this.parent;
        return mutableDataComponentHolder instanceof ItemStack ? (mutableDataComponentHolder = (itemStack = (ItemStack)mutableDataComponentHolder).getItem()) instanceof BaseTerraRepeaterItem && (repeaterItem = (BaseTerraRepeaterItem)mutableDataComponentHolder).getAllSupportedProjectiles(itemStack).test(stack) && is.get().booleanValue() : is.get();
    }

    protected void onContentsChanged(int slot, ItemStack oldStack, ItemStack newStack) {
    }

    public RepeaterContents getContents() {
        return (RepeaterContents)this.parent.getOrDefault(this.component, (Object)RepeaterContents.EMPTY);
    }

    protected ItemStack getStackFromContents(RepeaterContents contents, int slot) {
        this.validateSlotIndex(slot);
        return contents.getSlotSize() <= slot ? ItemStack.EMPTY : contents.getStackInSlot(slot);
    }

    protected void updateContents(RepeaterContents contents, ItemStack stack, int slot) {
        this.validateSlotIndex(slot);
        NonNullList list = NonNullList.withSize((int)Math.max(contents.getSlotSize(), this.getSlots()), (Object)ItemStack.EMPTY);
        ItemStack oldStack = (ItemStack)list.get(slot);
        contents.copyInto((NonNullList<ItemStack>)list);
        list.set(slot, (Object)stack);
        this.parent.set(this.component, (Object)RepeaterContents.fromItems((List<ItemStack>)list, this.capacity));
        this.onContentsChanged(slot, oldStack, stack);
    }

    protected final void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
    }
}

