/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.util;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.network.PacketDistributor;
import org.confluence.lib.api.entity.Boss;
import org.confluence.lib.util.LibDateUtils;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.attachment.EverBeneficial;
import org.confluence.mod.common.attachment.ExtraInventory;
import org.confluence.mod.common.attachment.ManaStorage;
import org.confluence.mod.common.attachment.PlayerPiggyBankContainer;
import org.confluence.mod.common.attachment.PlayerSpecialData;
import org.confluence.mod.common.attachment.SoulStorage;
import org.confluence.mod.common.data.map.DiggingPower;
import org.confluence.mod.common.data.saved.ConfluenceData;
import org.confluence.mod.common.data.saved.MoonPhase;
import org.confluence.mod.common.gameevent.BloodMoonGameEvent;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.init.armor.ModArmorBonus;
import org.confluence.mod.common.init.item.AccessoryItems;
import org.confluence.mod.common.init.item.ManaWeaponItems;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.mod.common.item.common.CoinItem;
import org.confluence.mod.common.item.potion.ManaPotionItem;
import org.confluence.mod.common.item.sword.BaseSwordItem;
import org.confluence.mod.mixed.ILevelChunkSection;
import org.confluence.mod.mixed.IMinecraftServer;
import org.confluence.mod.mixed.IServerPlayer;
import org.confluence.mod.network.s2c.BestiarySyncPacketS2C;
import org.confluence.mod.network.s2c.CompatibilitySyncPacketS2c;
import org.confluence.mod.network.s2c.ExtraInventorySyncPacketS2C;
import org.confluence.mod.network.s2c.FishingPowerInfoPacketS2C;
import org.confluence.mod.network.s2c.FlushArmorSetBonusPacketS2C;
import org.confluence.mod.network.s2c.GlobalCloakSyncPacketS2C;
import org.confluence.mod.network.s2c.KillBoardSyncPacketS2C;
import org.confluence.mod.network.s2c.ManaPacketS2C;
import org.confluence.mod.network.s2c.MeteoriteLocationPacketS2C;
import org.confluence.mod.network.s2c.PiggyBankTotalMoneyPacket;
import org.confluence.mod.network.s2c.SecretFlagSyncPacketS2C;
import org.confluence.mod.network.s2c.SoulPacketS2C;
import org.confluence.mod.network.s2c.StarPhasesPacketS2C;
import org.confluence.mod.network.s2c.VisibilityPacketS2C;
import org.confluence.mod.network.s2c.WindSpeedPacketS2C;
import org.confluence.mod.util.Coins;
import org.confluence.mod.util.DynamicBiomeUtils;
import org.confluence.mod.util.EnchantmentUtils;
import org.confluence.mod.util.FloatSupplier;
import org.confluence.mod.util.ModUtils;
import org.confluence.terra_curio.api.primitive.ValueType;
import org.confluence.terra_curio.common.init.TCItems;
import org.confluence.terra_curio.integration.bettercombat.BetterCombatHelper;
import org.confluence.terra_curio.util.TCUtils;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector3f;

public final class PlayerUtils {
    public static final ToIntFunction<Item> COIN_2_INDEX = coin -> {
        if (coin == ModItems.PLATINUM_COIN.get()) {
            return 0;
        }
        if (coin == ModItems.GOLD_COIN.get()) {
            return 1;
        }
        if (coin == ModItems.SILVER_COIN.get()) {
            return 2;
        }
        if (coin == ModItems.COPPER_COIN.get()) {
            return 3;
        }
        return -1;
    };
    public static final IntFunction<CoinItem> INDEX_2_COIN = index -> switch (index) {
        case 0 -> (CoinItem)((Object)((Object)ModItems.COPPER_COIN.get()));
        case 1 -> (CoinItem)((Object)((Object)ModItems.SILVER_COIN.get()));
        case 2 -> (CoinItem)((Object)((Object)ModItems.GOLD_COIN.get()));
        default -> (CoinItem)((Object)((Object)ModItems.PLATINUM_COIN.get()));
    };

    public static void syncMana2Client(ServerPlayer player, ManaStorage manaStorage) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ManaPacketS2C(manaStorage.getMaxMana(), manaStorage.getCurrentMana()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void syncMana2Client(ServerPlayer player) {
        PlayerUtils.syncMana2Client(player, ManaStorage.of((LivingEntity)player));
    }

    public static void syncSoul2Client(ServerPlayer player, SoulStorage soulStorage) {
        boolean isActive = PlayerSpecialData.of((Player)player).isFallenSoulCoreActive();
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SoulPacketS2C(soulStorage.getMaxSoul(), soulStorage.getCurrentSoul(), isActive), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void syncSoul2Client(ServerPlayer player) {
        PlayerUtils.syncSoul2Client(player, SoulStorage.of((LivingEntity)player));
    }

    public static void regenerateMana(ServerPlayer player) {
        ManaStorage manaStorage = ManaStorage.of((LivingEntity)player);
        if (!manaStorage.canReceive()) {
            return;
        }
        int delay = manaStorage.getRegenerateDelay();
        boolean notMove = PlayerUtils.isNotMove(player);
        if (delay > 0) {
            int delayReduce;
            if (manaStorage.isArcaneCrystalUsed()) {
                delay = (int)((float)delay * (notMove ? 0.975f : 0.95f));
            }
            if (delay > 20 && player.hasEffect(ModEffects.MANA_REGENERATION)) {
                delay = 20;
            }
            int n = delayReduce = notMove ? 2 : 1;
            if (manaStorage.isFastManaRegeneration()) {
                ++delayReduce;
            }
            manaStorage.setRegenerateDelay(delay - delayReduce);
            return;
        }
        boolean hasStarBottle = player.hasEffect(ModEffects.STAR_IN_A_BOTTLE);
        float starBottleBonusPerTick = hasStarBottle ? 0.25f : 0.0f;
        FloatSupplier receive = () -> {
            float a = (float)manaStorage.getMaxMana() * 0.14285715f + (float)(manaStorage.isFastManaRegeneration() ? 25 : 0) + 1.0f;
            if (notMove) {
                a += (float)manaStorage.getMaxMana() * 0.5f;
            }
            float b = manaStorage.getCurrentMana() * 0.8f / (float)manaStorage.getMaxMana() + 0.2f;
            float baseRegen = a * b * 0.0115f * EnchantmentUtils.processManaRegeneration(player);
            return baseRegen + starBottleBonusPerTick;
        };
        if (manaStorage.receiveMana(receive)) {
            PlayerUtils.syncMana2Client(player, manaStorage);
        }
    }

    private static boolean isNotMove(ServerPlayer player) {
        Vector3f vector3f = IServerPlayer.of(player).confluence$getMovementSpeed();
        return Math.abs(vector3f.x) < 1.0E-5f && Math.abs(vector3f.y) < 1.0E-5f && Math.abs(vector3f.z) < 1.0E-5f;
    }

    public static boolean extractMana(ServerPlayer player, ItemStack itemStack, FloatSupplier sup) {
        if (player.isCreative()) {
            return true;
        }
        ManaStorage manaStorage = ManaStorage.of((LivingEntity)player);
        if (!manaStorage.canExtract()) {
            return false;
        }
        if (itemStack.is(ManaWeaponItems.SPACE_GUN) && ModArmorBonus.hasType((Player)player, ModArmorBonus.SPACE$GUN$FREE)) {
            sup = () -> 0.0f;
        }
        if (manaStorage.extractMana(EnchantmentUtils.processEfficientMagic(sup, player), player)) {
            PlayerUtils.syncMana2Client(player, manaStorage);
            return true;
        }
        return false;
    }

    @Deprecated(since="1.2.0")
    @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
    public static boolean extractAndSync(ManaStorage manaStorage, FloatSupplier sup, ServerPlayer player) {
        return PlayerUtils.extractMana(player, ItemStack.EMPTY, sup);
    }

    public static void receiveMana(ServerPlayer player, FloatSupplier sup) {
        ManaStorage manaStorage = ManaStorage.of((LivingEntity)player);
        if (manaStorage.receiveMana(sup)) {
            PlayerUtils.syncMana2Client(player, manaStorage);
        }
    }

    public static void syncSavedData(ServerPlayer player) {
        ConfluenceData data = ConfluenceData.get(player.serverLevel());
        WindSpeedPacketS2C.sendToClient(player, data.getWindSpeedX(), data.getWindSpeedZ());
        if (((Boolean)CommonConfigs.STAR_PHASE.get()).booleanValue()) {
            StarPhasesPacketS2C.sendToClient(player, data.getStarPhases());
        }
        KillBoardSyncPacketS2C.sendToClient(player);
        GlobalCloakSyncPacketS2C.sendToClient(player);
        MeteoriteLocationPacketS2C.sendToClient(player, data.getMeteoriteLocation(), 0);
        BestiarySyncPacketS2C.syncEntries(player);
        ExtraInventorySyncPacketS2C.sendToClient(player, player, ExtraInventory.of((LivingEntity)player));
        PiggyBankTotalMoneyPacket.sendToClient(player, PlayerPiggyBankContainer.of((Player)player), true);
        FishingPowerInfoPacketS2C.sendAndGet(player);
        VisibilityPacketS2C.sendEcho(player);
        PlayerUtils.syncMana2Client(player);
        VisibilityPacketS2C.sendTheConstantPostEffect(player);
        SecretFlagSyncPacketS2C.sendToClient(player, IMinecraftServer.of(player.server).confluence$getSecretFlag());
        CompatibilitySyncPacketS2c.sendToClient(player);
    }

    public static float getFishingPower(ServerPlayer player) {
        Level level;
        float base = ((Float)TCUtils.getValue((LivingEntity)player, AccessoryItems.FISHING$POWER)).floatValue();
        if (EverBeneficial.of((LivingEntity)player).isGummyWormUsed()) {
            base += 3.0f;
        }
        if (player.isInFluidType() && TCUtils.hasType((LivingEntity)player, (ValueType)TCItems.FLOAT$ON$LIQUID$SURFACE)) {
            base += 5.0f;
        }
        if (player.hasEffect(ModEffects.TIPSY)) {
            base += 5.0f;
        }
        if ((level = player.level()).isRaining()) {
            base *= 1.1f;
        } else if (level.isThundering()) {
            base *= 1.2f;
        }
        int dayTime = LibDateUtils.getDayTime((Level)level);
        if (LibDateUtils.isWithinDayTime((int)LibDateUtils._04$30, (int)LibDateUtils._06$00, (int)dayTime)) {
            base *= 1.3f;
        } else if (LibDateUtils.isWithinDayTime((int)9, (int)0, (int)15, (int)0, (int)dayTime)) {
            base *= 0.8f;
        } else if (LibDateUtils.isWithinDayTime((int)LibDateUtils.getDayTime((int)18, (int)0), (int)LibDateUtils._19$30, (int)dayTime)) {
            base *= 1.3f;
        } else if (LibDateUtils.isWithinDayTime((int)21, (int)18, (int)2, (int)12, (int)dayTime)) {
            base *= 0.8f;
        }
        base *= (switch (MoonPhase.of(level)) {
            case MoonPhase.FULL_MOON -> 1.1f;
            case MoonPhase.WANING_GIBBOUS, MoonPhase.WAXING_GIBBOUS -> 1.05f;
            case MoonPhase.WAXING_CRESCENT -> 0.95f;
            case MoonPhase.NEW_MOON -> 0.9f;
            default -> 1.0f;
        });
        if (BloodMoonGameEvent.INSTANCE.started()) {
            base *= 1.1f;
        }
        return base;
    }

    public static Tuple<ItemStack, Integer> getMaxDiggingPowerItem(Player player) {
        int max = -1;
        ItemStack ret = ItemStack.EMPTY;
        for (ItemStack itemStack : player.getInventory().items) {
            int power;
            if (itemStack.isEmpty() || !itemStack.is(ItemTags.PICKAXES) || (power = DiggingPower.getPower(itemStack)) <= max) continue;
            max = power;
            ret = itemStack;
        }
        return new Tuple((Object)ret, (Object)max);
    }

    public static void consumeItemCount(Iterable<ItemStack> have, Item item, int consumeCount) {
        int count = 0;
        for (ItemStack stack : have) {
            if (!stack.is(item) || count >= consumeCount) continue;
            int toConsume = Math.min(stack.getCount(), consumeCount - count);
            stack.shrink(toConsume);
            count += toConsume;
        }
    }

    public static Coins getCoins(Player player, boolean withPiggyBank) {
        Coins coins = withPiggyBank ? PlayerUtils.decodeCoin(PlayerPiggyBankContainer.of(player).getTotalMoney()) : Coins.createEmpty();
        for (ItemStack stack : Iterables.concat((Iterable)player.getInventory().items, ExtraInventory.of((LivingEntity)player).getAllCoins())) {
            Item item;
            if (stack.isEmpty() || !((item = stack.getItem()) instanceof CoinItem)) continue;
            CoinItem coin = (CoinItem)item;
            coins.increase(coin, stack.getCount());
        }
        return coins;
    }

    @Deprecated(since="1.2.0")
    @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
    public static int[] getCoins(Player player) {
        Coins coins = PlayerUtils.getCoins(player, true);
        return new int[]{coins.platinum(), coins.gold(), coins.silver(), coins.copper()};
    }

    public static long getMoney(Player player, boolean withPiggyBank) {
        long res = withPiggyBank ? PlayerPiggyBankContainer.of(player).getTotalMoney() : 0L;
        for (ItemStack stack : Iterables.concat((Iterable)player.getInventory().items, ExtraInventory.of((LivingEntity)player).getAllCoins())) {
            int index;
            if (stack.isEmpty() || !stack.is(ModTags.Items.COINS) || (index = COIN_2_INDEX.applyAsInt(stack.getItem())) == -1) continue;
            res += (long)((double)stack.getCount() * Math.pow(100.0, 3 - index));
        }
        return res;
    }

    @Deprecated(since="1.2.0")
    @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
    public static long getMoney(Player player) {
        return PlayerUtils.getMoney(player, true);
    }

    public static boolean tryCostMoney(Player player, long cost, boolean withPiggyBank) {
        return PlayerUtils.tryCostMoney(PlayerUtils.getMoney(player, withPiggyBank), player, cost, withPiggyBank);
    }

    @Deprecated(since="1.2.0")
    @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
    public static boolean tryCostMoney(Player player, long cost) {
        return PlayerUtils.tryCostMoney(player, cost, true);
    }

    public static boolean tryCostMoney(long have, Player player, long cost, boolean withPiggyBank) {
        if (have < cost) {
            return false;
        }
        if (withPiggyBank) {
            long res = PlayerPiggyBankContainer.of(player).tryCostMoney(cost);
            if (res == 0L) {
                return true;
            }
            have -= cost - res;
            cost = res;
        }
        Inventory inventory = player.getInventory();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty() || !stack.is(ModTags.Items.COINS)) continue;
            inventory.setItem(i, ItemStack.EMPTY);
        }
        ExtraInventory extraInventory = ExtraInventory.of((LivingEntity)player);
        for (int i = 0; i < 4; ++i) {
            extraInventory.setCoins(i, ItemStack.EMPTY);
        }
        Coins coins = PlayerUtils.decodeCoin(have - cost);
        for (Object2IntMap.Entry entry : coins.copper2PlatinumEntries()) {
            int coin = entry.getIntValue();
            if (coin <= 0) continue;
            CoinItem coinItem = (CoinItem)((Object)entry.getKey());
            while (coin > 100) {
                inventory.add(new ItemStack((ItemLike)coinItem, 100));
                coin -= 100;
            }
            inventory.add(new ItemStack((ItemLike)coinItem, coin));
        }
        return true;
    }

    @Deprecated(since="1.2.0")
    @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
    public static boolean tryCostMoney(long have, Player player, long cost) {
        return PlayerUtils.tryCostMoney(have, player, cost, true);
    }

    public static Coins decodeCoin(long money) {
        if (money < 0L) {
            throw new IllegalArgumentException("Money cannot be negative");
        }
        int p = (int)(money / 1000000L);
        int g = (int)((money %= 1000000L) / 10000L);
        int s = (int)((money %= 10000L) / 100L);
        int c = (int)(money %= 100L);
        return new Coins(c, s, g, p);
    }

    public static Coins decodeCoin(int money) {
        int copper_count = money % 100;
        int i = (money - copper_count) / 100;
        int silver_count = i % 100;
        int j = (i - silver_count) / 100;
        int golden_count = j % 100;
        int k = (j - golden_count) / 100;
        return new Coins(copper_count, silver_count, golden_count, k);
    }

    public static void sortCoins(Player player) {
        int i;
        ExtraInventory extraInventory = ExtraInventory.of((LivingEntity)player);
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        for (i = 0; i < 4; ++i) {
            Supplier<CoinItem> upgrade;
            ItemStack coins = extraInventory.getCoins(i);
            if (coins.isEmpty() || !coins.is(ModTags.Items.COINS)) continue;
            extraInventory.setCoins(i, ItemStack.EMPTY);
            int index = COIN_2_INDEX.applyAsInt(coins.getItem());
            int count = coins.getCount();
            while (map.addTo((Object)index, count) + count >= 100 && (upgrade = PlayerUtils.INDEX_2_COIN.apply((int)(3 - index)).upgrade) != null) {
                map.addTo((Object)index, -100);
                index = COIN_2_INDEX.applyAsInt((Item)upgrade.get());
                count = 1;
            }
        }
        int j = 0;
        for (i = 0; i < 4; ++i) {
            int count = map.getInt((Object)i);
            if (count <= 0) continue;
            CoinItem coinItem = INDEX_2_COIN.apply(3 - i);
            while (count > 9999) {
                extraInventory.setCoins(j++, new ItemStack((ItemLike)coinItem, 9999));
                count -= 9999;
            }
            if (count <= 0) continue;
            extraInventory.setCoins(j++, new ItemStack((ItemLike)coinItem, count));
        }
    }

    public static void dropMoney(Player player) {
        long drops;
        if (!((Boolean)CommonConfigs.PLAYER_DROPS_MONEY.get()).booleanValue()) {
            return;
        }
        long money = PlayerUtils.getMoney(player, false);
        if (player.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY)) {
            int ratio = (Integer)LibUtils.switchByDifficulty((Level)player.level(), (BlockPos)player.blockPosition(), (Object)2, (Object)3, (Object)4);
            drops = money * (long)ratio / 4L;
        } else {
            drops = money;
        }
        PlayerUtils.tryCostMoney(money, player, drops, false);
        ModUtils.dropMoney(drops, player.getX(), player.getY(), player.getZ(), player.level());
        if (((Boolean)CommonConfigs.SHOW_MONEY_DROPS.get()).booleanValue()) {
            LibUtils.getOrCreatePersistedData((Player)player).putLong("confluence:drops_money", drops);
        }
    }

    public static int getRespawnWaitTime(ServerPlayer player) {
        int max;
        int min;
        AABB aabb = new AABB(player.blockPosition()).inflate(32767.0);
        if (player.level().getEntitiesOfClass(LivingEntity.class, aabb, living -> living instanceof Boss).isEmpty()) {
            min = (Integer)CommonConfigs.DEFAULT_RESPAWN_TIME_MIN.get();
            max = (Integer)CommonConfigs.DEFAULT_RESPAWN_TIME_MAX.get();
        } else {
            min = (Integer)CommonConfigs.BOSS_RESPAWN_TIME_MIN.get();
            max = (Integer)CommonConfigs.BOSS_RESPAWN_TIME_MAX.get();
        }
        if (min == max) {
            return min;
        }
        return player.getRandom().nextInt(Math.min(min, max), Math.max(min, max));
    }

    public static boolean applyAutoGetMana(ServerPlayer player, float currentMana, float extract) {
        if (currentMana < extract) {
            if (!TCUtils.hasType((LivingEntity)player, AccessoryItems.AUTO$GET$MANA)) {
                return true;
            }
            ItemStack toUse = null;
            for (ItemStack itemStack : player.getInventory().items) {
                ManaPotionItem manaPotion;
                int amount;
                Item item = itemStack.getItem();
                if (!(item instanceof ManaPotionItem) || currentMana + (float)(amount = (manaPotion = (ManaPotionItem)item).getAmount()) < extract) continue;
                if (toUse == null || amount < ((ManaPotionItem)toUse.getItem()).getAmount()) {
                    toUse = itemStack;
                }
                if (amount != 50) continue;
                break;
            }
            if (toUse == null) {
                return true;
            }
            toUse.finishUsingItem(player.level(), (LivingEntity)player);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean couldPerformEmptyTargetSweep(Player player) {
        if (player.isAutoSpinAttack()) return false;
        ItemStack stack = player.getMainHandItem();
        if (BetterCombatHelper.hasWeaponAttributes((ItemStack)stack)) {
            return false;
        }
        if (!stack.canPerformAction(ItemAbilities.SWORD_SWEEP)) return false;
        Item item = stack.getItem();
        if (!(item instanceof BaseSwordItem)) return false;
        BaseSwordItem sword = (BaseSwordItem)item;
        if (sword.modifier == null) return false;
        if (!sword.modifier.specialSweep) return false;
        return true;
    }

    public static boolean shouldSkipConsumeAmmo(Player player) {
        if (player.hasEffect(ModEffects.AMMO_BOX) && player.getRandom().nextFloat() < 0.2f) {
            return true;
        }
        return LibUtils.checkChance((float)((Float)ModArmorBonus.getValue(player, ModArmorBonus.SKIP$CONSUME$AMMO$CHANCE)).floatValue(), (RandomSource)player.getRandom());
    }

    public static void flushLocalData(ServerPlayer sendTo, ServerPlayer target) {
        ExtraInventorySyncPacketS2C.sendToClient(sendTo, target, ExtraInventory.of((LivingEntity)target));
        FlushArmorSetBonusPacketS2C.sendToClient(sendTo, target);
    }

    public static boolean skipHealIfOnFire(Player player) {
        return (Boolean)CommonConfigs.TERRA_STYLE_FIRE_DAMAGE.get() != false && player.isOnFire();
    }

    public static float applyTerraFire(DamageSource damageSource, float amount) {
        if (((Boolean)CommonConfigs.TERRA_STYLE_FIRE_DAMAGE.get()).booleanValue() && damageSource.is(DamageTypeTags.IS_FIRE)) {
            return amount * 4.0f;
        }
        return amount;
    }

    public static void applySunflowerEffect(ServerPlayer player, ServerLevel level, long gameTime) {
        ILevelChunkSection iSection;
        if (gameTime % 200L == 0L && (iSection = DynamicBiomeUtils.getISection((LevelAccessor)level, player.blockPosition())) != null && iSection.confluence$getBlockCounts().sunflower.get() > 0) {
            player.addEffect(new MobEffectInstance(ModEffects.HAPPY, 220));
        }
    }

    public static void flushPrimitiveValueData(ServerPlayer player) {
        ManaStorage.of((LivingEntity)player).flushAbility(player);
        FishingPowerInfoPacketS2C.sendAndGet(player);
        VisibilityPacketS2C.sendEcho(player);
    }
}

