/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.util;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import org.confluence.lib.util.ReturnException;
import org.confluence.mod.common.init.ModBiomes;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.init.block.OreBlocks;
import org.confluence.mod.mixed.ILevelChunkSection;
import org.confluence.mod.mixed.IPalettedContainer;
import org.confluence.mod.util.BlockCounts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DynamicBiomeUtils {
    public static final int BIOME_THRESHOLD = 256;
    public static final Map<Predicate<BlockState>, BiConsumer<BlockCounts, Integer>> COUNTER = new ImmutableMap.Builder().put(block -> block.is(ModTags.Blocks.CRIMSON_BLOCKS), (counter, count) -> counter.crimson.addAndGet((int)count)).put(block -> block.is(ModTags.Blocks.CRIMSON_DESERT_BLOCKS), (counter, count) -> counter.crimsonSand.addAndGet((int)count)).put(block -> block.is(ModTags.Blocks.CRIMSON_TUNDRA_BLOCKS), (counter, count) -> counter.crimsonIce.addAndGet((int)count)).put(block -> block.is(ModTags.Blocks.CORRUPTION_BLOCKS), (counter, count) -> counter.corrupt.addAndGet((int)count)).put(block -> block.is(ModTags.Blocks.CORRUPTED_DESERT_BLOCKS), (counter, count) -> counter.corruptSand.addAndGet((int)count)).put(block -> block.is(ModTags.Blocks.CORRUPTED_TUNDRA_BLOCKS), (counter, count) -> counter.corruptIce.addAndGet((int)count)).put(block -> block.is(ModTags.Blocks.HALLOW_BLOCKS), (counter, count) -> counter.hallow.addAndGet((int)count)).put(block -> block.is(ModTags.Blocks.HALLOW_DESERT_BLOCKS), (counter, count) -> counter.hallowSand.addAndGet((int)count)).put(block -> block.is(ModTags.Blocks.HALLOW_TUNDRA_BLOCKS), (counter, count) -> counter.hallowIce.addAndGet((int)count)).put(block -> block.is(ModTags.Blocks.GLOWING_MUSHROOM_BLOCKS), (counter, count) -> counter.glowing_mushroom.addAndGet((int)count)).put(block -> block.is(Blocks.SUNFLOWER), (counter, count) -> counter.sunflower.addAndGet((int)count)).put(block -> block.is(ModTags.Blocks.TOMBSTONE), (counter, count) -> counter.tomb.addAndGet((int)count)).put(block -> block.is(OreBlocks.CHLOROPHYTE_ORE), (counter, count) -> counter.chlorophyte.addAndGet((int)count)).put(block -> block.getFluidState().is(ModTags.Fluids.C_WATER), (counter, count) -> counter.water.addAndGet((int)count)).build();
    public static final Object2IntMap<ResourceKey<Biome>> PRIORITY = (Object2IntMap)Util.make((Object)new Object2IntOpenHashMap(), map -> {
        map.defaultReturnValue(Integer.MAX_VALUE);
        map.put(ModBiomes.THE_HALLOW_TUNDRA, 100);
        map.put(ModBiomes.THE_CORRUPTION_TUNDRA, 200);
        map.put(ModBiomes.THE_CRIMSON_TUNDRA, 300);
        map.put(ModBiomes.THE_HALLOW_DESERT, 400);
        map.put(ModBiomes.THE_CORRUPTION_DESERT, 500);
        map.put(ModBiomes.THE_CRIMSON_DESERT, 600);
        map.put(ModBiomes.THE_HALLOW, 700);
        map.put(ModBiomes.THE_CORRUPTION, 800);
        map.put(ModBiomes.THE_CRIMSON, 900);
        map.put(ModBiomes.GLOWING_MUSHROOM, 1000);
    });

    @NotNull
    public static PalettedContainer<Holder<Biome>> judgeBackupBiome(LevelChunkSection section, HolderLookup.RegistryLookup<Biome> lookup) {
        PalettedContainer biomes = (PalettedContainer)section.getBiomes();
        AtomicReference pure = new AtomicReference();
        AtomicBoolean hasEvil = new AtomicBoolean(false);
        try {
            biomes.getAll(biome -> {
                if (biome.is(ModTags.Biomes.SPREADABLE)) {
                    hasEvil.set(true);
                } else {
                    pure.set(biome);
                }
                if (pure.get() != null && hasEvil.get()) {
                    throw new ReturnException();
                }
            });
        }
        catch (ReturnException returnException) {
            // empty catch block
        }
        if (hasEvil.get()) {
            if (pure.get() == null) {
                return IPalettedContainer.recreateSingle(biomes, lookup.getOrThrow(Biomes.PLAINS));
            }
            return IPalettedContainer.recreateSingle(biomes, (Holder)pure.get());
        }
        return biomes;
    }

    @Nullable
    public static Holder<Biome> judgeSection(LevelChunkSection section, HolderLookup.RegistryLookup<Biome> lookup) {
        BlockCounts counts = ILevelChunkSection.of(section).confluence$getBlockCounts();
        int sunflower = counts.sunflower.get() * 64;
        int crimson = Math.max(0, counts.crimson.get() - sunflower);
        int corrupt = Math.max(0, counts.corrupt.get() - sunflower);
        int hallow = counts.hallow.get();
        int water = counts.water.get();
        int evil = Math.max(crimson, corrupt);
        crimson -= hallow;
        corrupt -= hallow;
        hallow -= evil;
        if (corrupt >= 256 && corrupt >= crimson) {
            if (counts.corruptSand.get() - water >= 256 || section.getBiomes().maybeHas(biomeHolder -> biomeHolder.is(Biomes.DESERT))) {
                return lookup.getOrThrow(ModBiomes.THE_CORRUPTION_DESERT);
            }
            if (counts.corruptIce.get() >= 256 || section.getBiomes().maybeHas(biomeHolder -> biomeHolder.is(BiomeTags.SPAWNS_SNOW_FOXES))) {
                return lookup.getOrThrow(ModBiomes.THE_CORRUPTION_TUNDRA);
            }
            return lookup.getOrThrow(ModBiomes.THE_CORRUPTION);
        }
        if (crimson >= 256) {
            if (counts.crimsonSand.get() - water >= 256 || section.getBiomes().maybeHas(biomeHolder -> biomeHolder.is(Biomes.DESERT))) {
                return lookup.getOrThrow(ModBiomes.THE_CRIMSON_DESERT);
            }
            if (counts.crimsonIce.get() >= 256 || section.getBiomes().maybeHas(biomeHolder -> biomeHolder.is(BiomeTags.SPAWNS_SNOW_FOXES))) {
                return lookup.getOrThrow(ModBiomes.THE_CRIMSON_TUNDRA);
            }
            return lookup.getOrThrow(ModBiomes.THE_CRIMSON);
        }
        if (hallow >= 256) {
            if (counts.hallowSand.get() - water >= 256 || section.getBiomes().maybeHas(biomeHolder -> biomeHolder.is(Biomes.DESERT))) {
                return lookup.getOrThrow(ModBiomes.THE_HALLOW_DESERT);
            }
            if (counts.hallowIce.get() >= 256 || section.getBiomes().maybeHas(biomeHolder -> biomeHolder.is(BiomeTags.SPAWNS_SNOW_FOXES))) {
                return lookup.getOrThrow(ModBiomes.THE_HALLOW_TUNDRA);
            }
            return lookup.getOrThrow(ModBiomes.THE_HALLOW);
        }
        if (counts.glowing_mushroom.get() >= 256) {
            return lookup.getOrThrow(ModBiomes.GLOWING_MUSHROOM);
        }
        return null;
    }

    @Nullable
    public static LevelChunkSection getSection(LevelAccessor level, BlockPos pos) {
        if (level.isOutsideBuildHeight(pos)) {
            return null;
        }
        return level.getChunk(pos).getSection(level.getSectionIndex(pos.getY()));
    }

    @Nullable
    public static ILevelChunkSection getISection(LevelAccessor level, BlockPos pos) {
        return ILevelChunkSection.of(DynamicBiomeUtils.getSection(level, pos));
    }

    public static void applyDynamicBiome(ChunkAccess chunk, HolderLookup.RegistryLookup<Biome> lookup) {
        Holder<Biome> belowBiome = null;
        for (LevelChunkSection section : chunk.getSections()) {
            section.recalcBlockCounts();
            Holder<Biome> currentBiome = DynamicBiomeUtils.judgeSection(section, lookup);
            if (currentBiome != null) {
                ILevelChunkSection.of(section).confluence$setBiomes((PalettedContainerRO<Holder<Biome>>)IPalettedContainer.recreateSingle(section.getBiomes(), currentBiome));
            } else if (belowBiome != null) {
                ILevelChunkSection.of(section).confluence$setBiomes((PalettedContainerRO<Holder<Biome>>)IPalettedContainer.recreateSingle(section.getBiomes(), belowBiome));
            }
            belowBiome = currentBiome;
        }
    }
}

