/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.util;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntSortedMap;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.mod.common.item.common.CoinItem;

public final class Coins {
    private int copper;
    private int silver;
    private int gold;
    private int platinum;
    private IntArrayList copper2Platinum;
    private IntArrayList platinum2Copper;
    private Object2IntLinkedOpenHashMap<CoinItem> copper2PlatinumMap;
    private Object2IntLinkedOpenHashMap<CoinItem> platinum2CopperMap;

    public Coins(int copper, int silver, int gold, int platinum) {
        this.copper = copper;
        this.silver = silver;
        this.gold = gold;
        this.platinum = platinum;
    }

    public int copper() {
        return this.copper;
    }

    public int silver() {
        return this.silver;
    }

    public int gold() {
        return this.gold;
    }

    public int platinum() {
        return this.platinum;
    }

    public void update(CoinItem coin, int count) {
        int index;
        if (coin == ModItems.COPPER_COIN.get()) {
            this.copper = count;
            index = 0;
        } else if (coin == ModItems.SILVER_COIN.get()) {
            this.silver = count;
            index = 1;
        } else if (coin == ModItems.GOLD_COIN.get()) {
            this.gold = count;
            index = 2;
        } else if (coin == ModItems.PLATINUM_COIN.get()) {
            this.platinum = count;
            index = 3;
        } else {
            return;
        }
        if (this.copper2Platinum != null) {
            this.copper2Platinum.set(index, count);
        }
        if (this.platinum2Copper != null) {
            this.platinum2Copper.set(3 - index, count);
        }
        if (this.copper2PlatinumMap != null) {
            this.copper2PlatinumMap.put((Object)coin, count);
        }
        if (this.platinum2CopperMap != null) {
            this.platinum2CopperMap.put((Object)coin, count);
        }
    }

    public void increase(CoinItem coin, int count) {
        this.update(coin, this.byItem(coin) + count);
    }

    public int byItem(CoinItem coin) {
        if (coin == ModItems.COPPER_COIN.get()) {
            return this.copper;
        }
        if (coin == ModItems.SILVER_COIN.get()) {
            return this.silver;
        }
        if (coin == ModItems.GOLD_COIN.get()) {
            return this.gold;
        }
        if (coin == ModItems.PLATINUM_COIN.get()) {
            return this.platinum;
        }
        return 0;
    }

    public IntList copper2Platinum() {
        if (this.copper2Platinum == null) {
            this.copper2Platinum = IntArrayList.of((int[])new int[]{this.copper, this.silver, this.gold, this.platinum});
        }
        return this.copper2Platinum;
    }

    public IntList platinum2Copper() {
        if (this.platinum2Copper == null) {
            this.platinum2Copper = IntArrayList.of((int[])new int[]{this.platinum, this.gold, this.silver, this.copper});
        }
        return this.platinum2Copper;
    }

    public Object2IntSortedMap.FastSortedEntrySet<CoinItem> copper2PlatinumEntries() {
        if (this.copper2PlatinumMap == null) {
            this.copper2PlatinumMap = new Object2IntLinkedOpenHashMap();
            this.copper2PlatinumMap.put((Object)((CoinItem)((Object)ModItems.COPPER_COIN.get())), this.copper);
            this.copper2PlatinumMap.put((Object)((CoinItem)((Object)ModItems.SILVER_COIN.get())), this.silver);
            this.copper2PlatinumMap.put((Object)((CoinItem)((Object)ModItems.GOLD_COIN.get())), this.gold);
            this.copper2PlatinumMap.put((Object)((CoinItem)((Object)ModItems.PLATINUM_COIN.get())), this.platinum);
        }
        return this.copper2PlatinumMap.object2IntEntrySet();
    }

    public Object2IntSortedMap.FastSortedEntrySet<CoinItem> platinum2CopperEntries() {
        if (this.platinum2CopperMap == null) {
            this.platinum2CopperMap = new Object2IntLinkedOpenHashMap();
            this.platinum2CopperMap.put((Object)((CoinItem)((Object)ModItems.PLATINUM_COIN.get())), this.platinum);
            this.platinum2CopperMap.put((Object)((CoinItem)((Object)ModItems.GOLD_COIN.get())), this.gold);
            this.platinum2CopperMap.put((Object)((CoinItem)((Object)ModItems.SILVER_COIN.get())), this.silver);
            this.platinum2CopperMap.put((Object)((CoinItem)((Object)ModItems.COPPER_COIN.get())), this.copper);
        }
        return this.platinum2CopperMap.object2IntEntrySet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (o == this) return true;
        if (!(o instanceof Coins)) return false;
        Coins that = (Coins)o;
        if (this.copper != that.copper) return false;
        if (this.silver != that.silver) return false;
        if (this.gold != that.gold) return false;
        if (this.platinum != that.platinum) return false;
        return true;
    }

    public int hashCode() {
        int result = this.copper;
        result = 31 * result + this.silver;
        result = 31 * result + this.gold;
        result = 31 * result + this.platinum;
        return result;
    }

    public String toString() {
        return "Coins[copper=" + this.copper + ", silver=" + this.silver + ", golden=" + this.gold + ", platinum=" + this.platinum + "]";
    }

    public static Coins createEmpty() {
        return new Coins(0, 0, 0, 0);
    }
}

