/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.network.s2c;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.confluence.lib.network.IPacketS2C;
import org.confluence.mod.Confluence;
import org.confluence.mod.client.handler.WeatherHandler;

public record WindSpeedPacketS2C(float x, float z) implements IPacketS2C
{
    public static final CustomPacketPayload.Type<WindSpeedPacketS2C> TYPE = Confluence.createType("wind_speed");
    public static final StreamCodec<ByteBuf, WindSpeedPacketS2C> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, WindSpeedPacketS2C::x, (StreamCodec)ByteBufCodecs.FLOAT, WindSpeedPacketS2C::z, WindSpeedPacketS2C::new);

    public CustomPacketPayload.Type<WindSpeedPacketS2C> type() {
        return TYPE;
    }

    public void work(Player player) {
        WeatherHandler.handleWindSpeed(this);
    }

    public static void sendToAll(float x, float z) {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new WindSpeedPacketS2C(x, z), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendToClient(ServerPlayer serverPlayer, float windSpeedX, float windSpeedZ) {
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new WindSpeedPacketS2C(windSpeedX, windSpeedZ), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

