/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.network.s2c;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.confluence.lib.network.IPacketS2C;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.attachment.PlayerPiggyBankContainer;

public record PiggyBankTotalMoneyPacket(long totalMoney) implements IPacketS2C
{
    public static final CustomPacketPayload.Type<PiggyBankTotalMoneyPacket> TYPE = Confluence.createType("piggy_bank_total_money");
    public static final StreamCodec<ByteBuf, PiggyBankTotalMoneyPacket> STREAM_CODEC = ByteBufCodecs.VAR_LONG.map(PiggyBankTotalMoneyPacket::new, PiggyBankTotalMoneyPacket::totalMoney);

    public CustomPacketPayload.Type<PiggyBankTotalMoneyPacket> type() {
        return TYPE;
    }

    public void work(Player player) {
        PlayerPiggyBankContainer.of(player).setTotalMoney(this.totalMoney);
    }

    public static void sendToClient(ServerPlayer player, PlayerPiggyBankContainer container, boolean update) {
        if (update) {
            container.setChanged();
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PiggyBankTotalMoneyPacket(container.getTotalMoney()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

