/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.network.s2c;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.confluence.lib.network.IPacketS2C;
import org.confluence.mod.Confluence;
import org.confluence.mod.client.gameevent.ClientGameEventSystem;
import org.confluence.mod.common.gameevent.GameEvent;

public record GameEventSyncPacketS2C(List<ResourceKey<? extends GameEvent>> keys, boolean start) implements IPacketS2C
{
    public static final CustomPacketPayload.Type<GameEventSyncPacketS2C> TYPE = Confluence.createType("game_event_sync");
    public static final StreamCodec<ByteBuf, GameEventSyncPacketS2C> STREAM_CODEC = StreamCodec.composite((StreamCodec)GameEvent.KEY_STREAM_CODEC.apply(ByteBufCodecs.list()), GameEventSyncPacketS2C::keys, (StreamCodec)ByteBufCodecs.BOOL, GameEventSyncPacketS2C::start, GameEventSyncPacketS2C::new);

    public void work(Player player) {
        ClientGameEventSystem.handlePacket(player, this.keys, this.start);
    }

    public CustomPacketPayload.Type<GameEventSyncPacketS2C> type() {
        return TYPE;
    }

    @SafeVarargs
    public static void sendToAll(boolean start, ResourceKey<? extends GameEvent> ... keys) {
        GameEventSyncPacketS2C.sendToAll(start, Arrays.stream(keys).toList());
    }

    public static void sendToAll(boolean start, List<ResourceKey<? extends GameEvent>> keys) {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new GameEventSyncPacketS2C(keys, start), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SafeVarargs
    public static void sentToClient(ServerPlayer player, boolean start, ResourceKey<? extends GameEvent> ... keys) {
        GameEventSyncPacketS2C.sentToClient(player, start, Arrays.stream(keys).toList());
    }

    public static void sentToClient(ServerPlayer player, boolean start, List<ResourceKey<? extends GameEvent>> keys) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new GameEventSyncPacketS2C(keys, start), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sentToClient(ServerPlayer player, List<ResourceKey<? extends GameEvent>> started, List<ResourceKey<? extends GameEvent>> ended) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new GameEventSyncPacketS2C(started, true), (CustomPacketPayload[])new CustomPacketPayload[]{new GameEventSyncPacketS2C(ended, false)});
    }
}

