/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.network.s2c;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.neoforge.network.PacketDistributor;
import org.confluence.lib.network.IPacketS2C;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.client.handler.DropletsHandler;

public record DropletsSyncPacketS2C(Map<ChunkPos, Map<BlockPos, ParticleOptions>> data) implements IPacketS2C
{
    public static final CustomPacketPayload.Type<DropletsSyncPacketS2C> TYPE = Confluence.createType("droplets_sync");
    public static final StreamCodec<RegistryFriendlyByteBuf, DropletsSyncPacketS2C> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, DropletsSyncPacketS2C>(){

        public DropletsSyncPacketS2C decode(RegistryFriendlyByteBuf buffer) {
            int amount = buffer.readVarInt();
            HashMap<ChunkPos, Map<BlockPos, ParticleOptions>> mapMap = new HashMap<ChunkPos, Map<BlockPos, ParticleOptions>>();
            for (int i = 0; i < amount; ++i) {
                ChunkPos pos = buffer.readChunkPos();
                int size = buffer.readVarInt();
                HashMap<BlockPos, ParticleOptions> map = new HashMap<BlockPos, ParticleOptions>();
                for (int j = 0; j < size; ++j) {
                    BlockPos blockPos = LibUtils.decompressRelativePos((ChunkPos)pos, (int)buffer.readVarInt());
                    ParticleOptions particle = (ParticleOptions)ParticleTypes.STREAM_CODEC.decode((Object)buffer);
                    map.put(blockPos, particle);
                }
                mapMap.put(pos, map);
            }
            return new DropletsSyncPacketS2C(mapMap);
        }

        public void encode(RegistryFriendlyByteBuf buffer, DropletsSyncPacketS2C value) {
            buffer.writeVarInt(value.data.size());
            for (Map.Entry<ChunkPos, Map<BlockPos, ParticleOptions>> entry : value.data.entrySet()) {
                buffer.writeChunkPos(entry.getKey());
                buffer.writeVarInt(entry.getValue().size());
                for (Map.Entry<BlockPos, ParticleOptions> entry1 : entry.getValue().entrySet()) {
                    buffer.writeVarInt(LibUtils.compressRelativePos((BlockPos)entry1.getKey()));
                    ParticleTypes.STREAM_CODEC.encode((Object)buffer, (Object)entry1.getValue());
                }
            }
        }
    };

    public CustomPacketPayload.Type<DropletsSyncPacketS2C> type() {
        return TYPE;
    }

    public void work(Player player) {
        DropletsHandler.handlePacket(this);
    }

    public static void sendToClient(ServerPlayer player, Map<ChunkPos, Map<BlockPos, ParticleOptions>> dataMap) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new DropletsSyncPacketS2C(dataMap), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToPlayersTrackingChunk(ServerLevel level, ChunkPos chunkPos, Map<ChunkPos, Map<BlockPos, ParticleOptions>> dataMap) {
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level, (ChunkPos)chunkPos, (CustomPacketPayload)new DropletsSyncPacketS2C(dataMap), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

