/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.network.s2c;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.confluence.lib.network.IPacketS2C;
import org.confluence.mod.Confluence;
import org.confluence.mod.mixed.IEntity;

public record DeathMotionPacketS2C(int entityId, float x, float y, float z) implements IPacketS2C
{
    public static final CustomPacketPayload.Type<DeathMotionPacketS2C> TYPE = Confluence.createType("death_motion");
    public static final StreamCodec<ByteBuf, DeathMotionPacketS2C> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, DeathMotionPacketS2C::entityId, (StreamCodec)ByteBufCodecs.FLOAT, DeathMotionPacketS2C::x, (StreamCodec)ByteBufCodecs.FLOAT, DeathMotionPacketS2C::y, (StreamCodec)ByteBufCodecs.FLOAT, DeathMotionPacketS2C::z, DeathMotionPacketS2C::new);

    public DeathMotionPacketS2C(int entityId, Vec3 motion) {
        this(entityId, (float)motion.x, (float)motion.y, (float)motion.z);
    }

    public CustomPacketPayload.Type<DeathMotionPacketS2C> type() {
        return TYPE;
    }

    public void work(Player player) {
        Entity entity = player.level().getEntity(this.entityId);
        if (entity instanceof IEntity) {
            LivingEntity living;
            IEntity entity2 = (IEntity)entity;
            entity2.confluence$deathMotion(new Vec3((double)this.x, (double)this.y, (double)this.z));
            if (entity2 instanceof LivingEntity && (living = (LivingEntity)entity2).isDeadOrDying()) {
                Confluence.LOGGER.warn("Receive death motion packet but entity is dying");
            }
        }
    }

    public static void sendToAll(LivingEntity living) {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            Vec3 motion = living.getDeltaMovement();
            if (motion.length() == 0.0) {
                Vec3 pos = living.position();
                motion = new Vec3(pos.x - living.xo, pos.y - living.yo, pos.z - living.zo);
            }
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new DeathMotionPacketS2C(living.getId(), motion), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendToClient(ServerPlayer serverPlayer, int entityId, Vec3 motion) {
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new DeathMotionPacketS2C(entityId, motion), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

