/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.network.s2c;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Hashtable;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.confluence.lib.network.IPacketS2C;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.client.effect.textures.LocalBrushData;
import org.confluence.mod.common.attachment.ChunkBrushData;
import org.confluence.mod.common.data.saved.BrushData;
import org.jetbrains.annotations.Nullable;

public record BrushingColorPacketS2C(ChunkPos chunkPos, BrushData data) implements IPacketS2C
{
    public static final CustomPacketPayload.Type<BrushingColorPacketS2C> TYPE = Confluence.createType("brushing_color");
    public static final StreamCodec<RegistryFriendlyByteBuf, BrushingColorPacketS2C> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, BrushingColorPacketS2C>(){

        public BrushingColorPacketS2C decode(RegistryFriendlyByteBuf buffer) {
            ChunkPos chunkPos = buffer.readChunkPos();
            int size = buffer.readVarInt();
            Hashtable<BlockPos, int[]> map = new Hashtable<BlockPos, int[]>();
            for (int i = 0; i < size; ++i) {
                BlockPos blockAt = LibUtils.decompressRelativePos((ChunkPos)chunkPos, (int)buffer.readInt());
                int[] list = map.computeIfAbsent(blockAt, BrushData.COMPUTE);
                byte face = buffer.readByte();
                for (int l = 0; l < 6; ++l) {
                    int m = 1 << l;
                    if ((face & m) != m) continue;
                    list[LibUtils.DIRECTIONS[l].get3DDataValue()] = buffer.readInt();
                }
            }
            return new BrushingColorPacketS2C(chunkPos, new BrushData(map));
        }

        public void encode(RegistryFriendlyByteBuf buffer, BrushingColorPacketS2C value) {
            buffer.writeChunkPos(value.chunkPos);
            Map<BlockPos, int[]> map = value.data.colors();
            buffer.writeVarInt(map.size());
            for (Map.Entry<BlockPos, int[]> entry : map.entrySet()) {
                int c;
                buffer.writeInt(LibUtils.compressRelativePos((BlockPos)entry.getKey()));
                int[] color = entry.getValue();
                byte face = 0;
                IntArrayList list = new IntArrayList();
                for (int i = 0; i < 6; ++i) {
                    c = color[i];
                    if (c == -1) continue;
                    face = (byte)(face | (byte)(1 << i));
                    list.add(c);
                }
                buffer.writeByte(face);
                IntListIterator intListIterator = list.iterator();
                while (intListIterator.hasNext()) {
                    c = (Integer)intListIterator.next();
                    buffer.writeInt(c);
                }
            }
        }
    };
    public static final int[] CLEAR_COLORS = BrushData.createColor(-2);

    public CustomPacketPayload.Type<BrushingColorPacketS2C> type() {
        return TYPE;
    }

    public void work(Player player) {
        LocalBrushData.handlePacket(this);
    }

    public static void sendToClient(ServerPlayer serverPlayer, ChunkPos chunkPos, BrushData data, boolean save) {
        if (save) {
            BrushingColorPacketS2C.saveData(serverPlayer.serverLevel(), chunkPos, data);
        }
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new BrushingColorPacketS2C(chunkPos, data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToPlayersTrackingChunk(ServerLevel level, ChunkPos chunkPos, BrushData data, boolean save) {
        if (save) {
            BrushingColorPacketS2C.saveData(level, chunkPos, data);
        }
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level, (ChunkPos)chunkPos, (CustomPacketPayload)new BrushingColorPacketS2C(chunkPos, data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToPlayersTrackingChunk(ServerLevel level, BlockPos pos, @Nullable Direction facing, int color, boolean save) {
        if (color == -5 || !level.getBlockState(pos).isSolidRender((BlockGetter)level, pos)) {
            facing = null;
        }
        BrushingColorPacketS2C.sendToPlayersTrackingChunk(level, new ChunkPos(pos), new BrushData(pos, facing, color), save);
    }

    public static void remove(ServerLevel level, BlockPos pos, Direction facing) {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            ChunkPos chunkPos = new ChunkPos(pos);
            BrushData brushData = ChunkBrushData.of((Level)level).getDataMap().get(chunkPos);
            if (brushData == null) {
                return;
            }
            if (level.getBlockState(pos).isSolidRender((BlockGetter)level, pos)) {
                brushData.remove(pos, facing);
            } else {
                brushData.remove(pos);
                facing = null;
            }
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new BrushingColorPacketS2C(chunkPos, new BrushData(pos, facing, -2)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void remove(ServerLevel level, BlockPos pos) {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            ChunkPos chunkPos = new ChunkPos(pos);
            BrushData brushData = ChunkBrushData.of((Level)level).getDataMap().get(chunkPos);
            if (brushData == null) {
                return;
            }
            brushData.remove(pos);
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new BrushingColorPacketS2C(chunkPos, new BrushData(Map.of(pos, CLEAR_COLORS))), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static void saveData(ServerLevel level, ChunkPos chunkPos, BrushData data) {
        ChunkBrushData.of((Level)level).getDataMap().computeIfAbsent(chunkPos, pos -> new BrushData(new Hashtable<BlockPos, int[]>())).merge(data);
    }
}

