/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.network.c2s;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.confluence.lib.network.IPacketC2S;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.component.SwordProjectileComponent;
import org.confluence.mod.common.init.ModDataComponentTypes;
import org.confluence.mod.common.item.sword.BaseSwordItem;

public class SwordProjectilePacketC2S
implements IPacketC2S {
    private static final SwordProjectilePacketC2S INSTANCE = new SwordProjectilePacketC2S();
    public static final CustomPacketPayload.Type<SwordProjectilePacketC2S> TYPE = Confluence.createType("sword_projectile");
    public static final StreamCodec<ByteBuf, SwordProjectilePacketC2S> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);

    private SwordProjectilePacketC2S() {
    }

    public CustomPacketPayload.Type<SwordProjectilePacketC2S> type() {
        return TYPE;
    }

    public void work(ServerPlayer player) {
        ItemStack stack = player.getMainHandItem();
        Item item = stack.getItem();
        if (item instanceof BaseSwordItem) {
            BaseSwordItem sword = (BaseSwordItem)item;
            if (!player.getCooldowns().isOnCooldown((Item)sword)) {
                SwordProjectileComponent data = (SwordProjectileComponent)stack.get(ModDataComponentTypes.SWORD_PROJECTILE);
                if (data == null) {
                    return;
                }
                sword.genProjectile((LivingEntity)player, stack, data);
                player.getCooldowns().addCooldown((Item)sword, data.getAttackSpeed((LivingEntity)player));
            }
        }
    }

    public static void sendToServer() {
        PacketDistributor.sendToServer((CustomPacketPayload)INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

