/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.network.c2s;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.confluence.lib.network.IPacketC2S;
import org.confluence.mod.Confluence;
import org.confluence.mod.integration.terra_entity.npc_trade.SellTrade;
import org.confluence.terraentity.api.npc.trade.ITradeHolder;
import org.confluence.terraentity.mixed.IPlayer;

public record SellTradePacketC2S(int tradeIndex) implements IPacketC2S
{
    public static final CustomPacketPayload.Type<SellTradePacketC2S> TYPE = Confluence.createType("sell_trade_c2s");
    public static final StreamCodec<ByteBuf, SellTradePacketC2S> STREAM_CODEC = ByteBufCodecs.VAR_INT.map(SellTradePacketC2S::new, SellTradePacketC2S::tradeIndex);

    public CustomPacketPayload.Type<SellTradePacketC2S> type() {
        return TYPE;
    }

    public void work(ServerPlayer player) {
        ITradeHolder iTradeHolder = IPlayer.of((Player)player).terra_entity$getTradeHolder();
        if (iTradeHolder instanceof ITradeHolder) {
            ITradeHolder holder = iTradeHolder;
            if (this.tradeIndex >= 0) {
                SellTrade.INSTANCE.onSell(player, holder, this.tradeIndex);
            }
        }
    }

    public static void sendToServer(int selected) {
        PacketDistributor.sendToServer((CustomPacketPayload)new SellTradePacketC2S(selected), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

