/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.network.c2s;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.confluence.lib.network.IPacketC2S;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.attachment.ManaStorage;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.item.potion.HealingPotionItem;
import org.confluence.mod.common.item.potion.ManaPotionItem;

public record KeyRequestPacketC2S(byte key) implements IPacketC2S
{
    public static final byte KEY_HEALING = 0;
    public static final byte KEY_MANA = 1;
    public static final byte KEY_CLAIRVOYANCE = 2;
    public static final CustomPacketPayload.Type<KeyRequestPacketC2S> TYPE = Confluence.createType("key_request");
    public static final StreamCodec<ByteBuf, KeyRequestPacketC2S> STREAM_CODEC = ByteBufCodecs.BYTE.map(KeyRequestPacketC2S::new, KeyRequestPacketC2S::key);

    public CustomPacketPayload.Type<KeyRequestPacketC2S> type() {
        return TYPE;
    }

    public void work(ServerPlayer player) {
        if (this.key == 0) {
            HealingPotionItem.use((Player)player);
        } else if (this.key == 1) {
            ManaPotionItem.use((Player)player);
        } else if (this.key == 2) {
            player.addEffect(new MobEffectInstance(ModEffects.CLAIRVOYANCE, -1));
            ManaStorage.of((LivingEntity)player).flushAbility(player);
        }
    }

    public static void requestHealing() {
        PacketDistributor.sendToServer((CustomPacketPayload)new KeyRequestPacketC2S(0), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void requestMana() {
        PacketDistributor.sendToServer((CustomPacketPayload)new KeyRequestPacketC2S(1), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void requestClairvoyance() {
        PacketDistributor.sendToServer((CustomPacketPayload)new KeyRequestPacketC2S(2), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

