/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.network.c2s;

import io.netty.buffer.ByteBuf;
import java.util.Comparator;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.network.PacketDistributor;
import org.confluence.lib.network.IPacketC2S;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.data.saved.NPCSpawner;
import org.confluence.mod.integration.terra_entity.IAbstractTerraNPC;
import org.confluence.mod.network.s2c.AvailableHouseSelectPacketS2C;
import org.confluence.terraentity.entity.npc.AbstractTerraNPC;
import org.confluence.terraentity.entity.npc.house.House;
import org.confluence.terraentity.entity.npc.house.HouseManager;
import org.confluence.terraentity.entity.npc.house.IHouseDetector;

public record HouseSelectPacketC2S(int selected, BlockPos pos) implements IPacketC2S
{
    public static final CustomPacketPayload.Type<HouseSelectPacketC2S> TYPE = Confluence.createType("house_select");
    public static final StreamCodec<ByteBuf, HouseSelectPacketC2S> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, HouseSelectPacketC2S::selected, (StreamCodec)BlockPos.STREAM_CODEC, HouseSelectPacketC2S::pos, HouseSelectPacketC2S::new);

    public CustomPacketPayload.Type<HouseSelectPacketC2S> type() {
        return TYPE;
    }

    public void work(ServerPlayer player) {
        House house = HouseManager.getInstance().isInsideHouse(this.pos);
        boolean isEmptyHouse = house == null || house.uuid().isEmpty();
        IHouseDetector detect = IHouseDetector.detect((BlockPos)this.pos, (Level)player.level());
        EntityType<?> type = AvailableHouseSelectPacketS2C.getTypes()[this.selected];
        NPCSpawner.Region region = new NPCSpawner.Region(this.pos);
        if (this.selected == 0) {
            if (isEmptyHouse) {
                player.sendSystemMessage((Component)Component.translatable((String)detect.message()));
            } else {
                Entity entity = player.serverLevel().getEntity((UUID)house.uuid().get());
                if (entity instanceof AbstractTerraNPC) {
                    AbstractTerraNPC npc2 = (AbstractTerraNPC)entity;
                    player.sendSystemMessage((Component)Component.translatable((String)"message.confluence.house_detect.occupied", (Object[])new Object[]{npc2.getType().getDescription(), npc2.getDisplayName()}));
                } else {
                    player.sendSystemMessage((Component)Component.translatable((String)"message.confluence.house_detect.npc_not_fount"));
                }
            }
        } else if (detect.isError()) {
            player.sendSystemMessage((Component)Component.translatable((String)detect.message()));
        } else if (isEmptyHouse) {
            this.getNpc(player, type, region, npc -> {
                House house1 = detect.getHouse(npc.getUUID());
                if (HouseManager.getInstance().tryAddHouse(house1)) {
                    NPCSpawner.INSTANCE.moveNPCToAnotherRegion((AbstractTerraNPC)npc, IAbstractTerraNPC.of(npc).confluence$getRegion(), new NPCSpawner.Region(this.pos));
                    npc.setHouse(house1);
                    player.sendSystemMessage((Component)Component.translatable((String)"tooltip.terra_entity.house_detect.mode.add.success"));
                }
            });
        } else {
            Entity entity = player.serverLevel().getEntity((UUID)house.uuid().get());
            if (entity instanceof AbstractTerraNPC) {
                AbstractTerraNPC npc3 = (AbstractTerraNPC)entity;
                if (npc3.getType() == type) {
                    HouseManager.getInstance().removeHouse(npc3.getUUID());
                    npc3.setHouse(House.EMPTY);
                    player.sendSystemMessage((Component)Component.translatable((String)"tooltip.terra_entity.house_detect.mode.delete.success"));
                } else {
                    player.sendSystemMessage((Component)Component.translatable((String)"message.confluence.house_detect.occupied", (Object[])new Object[]{npc3.getType().getDescription(), npc3.getDisplayName()}));
                }
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"message.confluence.house_detect.npc_not_fount"));
            }
        }
    }

    private void getNpc(ServerPlayer player, EntityType<?> type, NPCSpawner.Region region, Consumer<AbstractTerraNPC> ifSuccess) {
        player.serverLevel().getEntitiesOfClass(AbstractTerraNPC.class, new AABB(this.pos).inflate((double)(player.requestedViewDistance() * 16))).stream().filter(npc -> npc.getType() == type).filter(npc -> npc.getSpawnAtPos() != null && region.isOnRegion(npc.getSpawnAtPos())).min(Comparator.comparingDouble(npc -> npc.distanceToSqr((Entity)player))).ifPresentOrElse(ifSuccess, () -> player.sendSystemMessage((Component)Component.translatable((String)"message.confluence.house_detect.npc_not_fount")));
    }

    public static void sendToServer(int selected, BlockPos pos) {
        PacketDistributor.sendToServer((CustomPacketPayload)new HouseSelectPacketC2S(selected, pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

