/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.network.c2s;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.confluence.lib.network.IPacketC2S;
import org.confluence.mod.Confluence;

public record DyeMixPacketC2S(ItemStack stack) implements IPacketC2S
{
    public static final CustomPacketPayload.Type<DyeMixPacketC2S> TYPE = Confluence.createType("dye_mix");
    public static final StreamCodec<RegistryFriendlyByteBuf, DyeMixPacketC2S> STREAM_CODEC = ItemStack.OPTIONAL_STREAM_CODEC.map(DyeMixPacketC2S::new, DyeMixPacketC2S::stack);

    public CustomPacketPayload.Type<DyeMixPacketC2S> type() {
        return TYPE;
    }

    public void work(ServerPlayer player) {
        AbstractContainerMenu menu = player.containerMenu;
        Slot red = menu.getSlot(0);
        Slot green = menu.getSlot(1);
        Slot blue = menu.getSlot(2);
        if (red.hasItem() && green.hasItem() && blue.hasItem()) {
            red.remove(1);
            green.remove(1);
            blue.remove(1);
            ItemStack carried = menu.getCarried();
            if (carried.isEmpty()) {
                menu.setCarried(this.stack);
            } else if (ItemStack.isSameItemSameComponents((ItemStack)carried, (ItemStack)this.stack) && carried.getCount() < carried.getMaxStackSize()) {
                carried.grow(1);
            }
        }
    }

    public static void sendToServer(ItemStack stack) {
        PacketDistributor.sendToServer((CustomPacketPayload)new DyeMixPacketC2S(stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

