/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.network.c2s;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.confluence.lib.network.IPacketC2S;
import org.confluence.mod.Confluence;
import org.jetbrains.annotations.Nullable;

public record ApplySelectionPacketC2S(byte selected) implements IPacketC2S
{
    public static final CustomPacketPayload.Type<ApplySelectionPacketC2S> TYPE = Confluence.createType("apply_selection_c2s");
    public static final StreamCodec<ByteBuf, ApplySelectionPacketC2S> STREAM_CODEC = ByteBufCodecs.BYTE.map(ApplySelectionPacketC2S::new, ApplySelectionPacketC2S::selected);

    public CustomPacketPayload.Type<ApplySelectionPacketC2S> type() {
        return TYPE;
    }

    public void work(ServerPlayer player) {
        ItemStack itemStack = player.getMainHandItem();
        Item item = itemStack.getItem();
        if (item instanceof ISelectable) {
            ISelectable selectable = (ISelectable)item;
            selectable.applySelected(this.selected, itemStack, player);
        }
    }

    public static void sendToServer(byte selected) {
        PacketDistributor.sendToServer((CustomPacketPayload)new ApplySelectionPacketC2S(selected), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static interface ISelectable<T> {
        @Nullable
        public T getSelected(byte var1, ItemStack var2);

        public void applySelected(byte var1, ItemStack var2, ServerPlayer var3);
    }
}

