/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixin.integration.ars_nouveau;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.integration.ars_nouveau.ArsNouveauHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Pseudo
@Mixin(targets={"com.hollingsworth.arsnouveau.common.capability.ManaCap"}, remap=false)
public abstract class ManaCapMixin {
    @Shadow
    LivingEntity entity;
    @Unique
    private Player confluence$player;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(LivingEntity livingEntity, CallbackInfo ci) {
        if (((Boolean)CommonConfigs.CONVERT_ARS_NOUVEAU_MANA.get()).booleanValue() && livingEntity instanceof Player) {
            Player player;
            this.confluence$player = player = (Player)livingEntity;
        }
    }

    @Inject(method={"setMaxMana"}, at={@At(value="TAIL")})
    private void updateMana(int maxMana, CallbackInfo ci) {
        ArsNouveauHelper.updateMana(this.entity);
    }

    @Inject(method={"removeMana"}, at={@At(value="RETURN")})
    private void removeData(double manaToRemove, CallbackInfoReturnable<Double> cir) {
        Player player = this.confluence$player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ArsNouveauHelper.extractMana(player2, manaToRemove);
        }
    }
}

