/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixin.client.gui;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.confluence.mod.mixed.IDeathScreen;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DeathScreen.class})
public abstract class DeathScreenMixin
extends Screen
implements IDeathScreen {
    @Shadow
    private int delayTicker;
    @Shadow
    @Final
    private boolean hardcore;
    @Shadow
    private Component deathScore;
    @Unique
    private Button confluence$respawnButton;
    @Unique
    private int confluence$respawnWaitTime;
    @Unique
    private Component confluence$respawnTimeComponent = Component.empty();

    protected DeathScreenMixin(Component pTitle) {
        super(pTitle);
    }

    @Shadow
    protected abstract void exitToTitleScreen();

    @Override
    public void confluence$setDelayTicker(int ticker) {
        this.delayTicker = ticker;
    }

    @Override
    public void confluence$setRespawnWaitTime(int time) {
        this.confluence$respawnWaitTime = time;
    }

    @Override
    public void confluence$setDropsMoney(MutableComponent prefix) {
        this.deathScore = prefix.append(", ").append(this.deathScore);
    }

    @ModifyExpressionValue(method={"init"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/DeathScreen;addRenderableWidget(Lnet/minecraft/client/gui/components/events/GuiEventListener;)Lnet/minecraft/client/gui/components/events/GuiEventListener;", ordinal=0)})
    private GuiEventListener setInactive(GuiEventListener original) {
        if (!this.hardcore && original instanceof Button) {
            Button button;
            this.confluence$respawnButton = button = (Button)original;
            button.active = false;
        }
        return original;
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick, CallbackInfo ci) {
        if (this.confluence$respawnWaitTime >= this.delayTicker) {
            pGuiGraphics.drawCenteredString(this.font, this.confluence$respawnTimeComponent, this.width / 2, 120, 0xFFFFFF);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo ci) {
        if (this.delayTicker >= this.confluence$respawnWaitTime && this.confluence$respawnButton != null) {
            this.confluence$respawnButton.active = true;
        }
        this.confluence$respawnTimeComponent = Component.translatable((String)"info.confluence.respawn_time", (Object[])new Object[]{(this.confluence$respawnWaitTime - this.delayTicker) / 20}).withStyle(ChatFormatting.GRAY);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/DeathScreen;setButtonsActive(Z)V", shift=At.Shift.AFTER)})
    private void setInactive(CallbackInfo ci) {
        if (this.confluence$respawnButton != null) {
            this.confluence$respawnButton.active = false;
        }
    }

    @Inject(method={"handleExitToTitleScreen"}, at={@At(value="HEAD")}, cancellable=true)
    private void confirmExit(CallbackInfo ci) {
        if (this.delayTicker < this.confluence$respawnWaitTime) {
            this.exitToTitleScreen();
            ci.cancel();
        }
    }
}

