/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.server.WorldStem;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.confluence.mod.client.ModKeyBindings;
import org.confluence.mod.client.effect.GlowingHelper;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.mixed.ILevelLoadingScreen;
import org.confluence.mod.mixed.IWorldOptions;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin {
    @Shadow
    @Nullable
    public LocalPlayer player;

    @Inject(method={"doWorldLoad"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setScreen(Lnet/minecraft/client/gui/screens/Screen;)V")})
    private void setSecretFlag(LevelStorageSource.LevelStorageAccess levelStorage, PackRepository packRepository, WorldStem worldStem, boolean newWorld, CallbackInfo ci, @Local LevelLoadingScreen levelloadingscreen) {
        ILevelLoadingScreen.of(levelloadingscreen).confluence$setSecretFlag(IWorldOptions.of(worldStem.worldData().worldGenOptions()).confluence$getSecretFlag());
    }

    @Inject(method={"shouldEntityAppearGlowing"}, at={@At(value="HEAD")}, cancellable=true)
    public void changeGlowOutline(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        if (this.player != null) {
            GlowingHelper helper = GlowingHelper.INSTANCE;
            if (this.player.hasEffect(ModEffects.HUNTER)) {
                for (Class<? extends Entity> n : helper.hunterCatalog) {
                    if (!n.isAssignableFrom(entity.getClass())) continue;
                    if (((KeyMapping)ModKeyBindings.SHOW_DETAIL_SPECULAR.get()).isDown()) {
                        cir.setReturnValue((Object)true);
                        return;
                    }
                    cir.setReturnValue((Object)helper.colorMap.get(n).alwaysShow());
                    return;
                }
                if (entity instanceof Enemy) {
                    cir.setReturnValue((Object)true);
                    return;
                }
                if (entity instanceof NeutralMob) {
                    if (((KeyMapping)ModKeyBindings.SHOW_DETAIL_SPECULAR.get()).isDown()) {
                        cir.setReturnValue((Object)true);
                        return;
                    }
                    if (helper.alwaysShowNeutral) {
                        cir.setReturnValue((Object)true);
                        return;
                    }
                }
            }
            if (this.player.hasEffect(ModEffects.DANGER_SENSE)) {
                for (Class<? extends Entity> n : helper.dangerCatalog) {
                    if (!n.isAssignableFrom(entity.getClass())) continue;
                    if (((KeyMapping)ModKeyBindings.SHOW_DETAIL_SPECULAR.get()).isDown()) {
                        cir.setReturnValue((Object)true);
                        return;
                    }
                    cir.setReturnValue((Object)helper.colorMap.get(n).alwaysShow());
                    return;
                }
            }
        }
    }
}

