/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixin.block;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.lib.common.block.StateProperties;
import org.confluence.mod.common.attachment.ChunkBrushData;
import org.confluence.mod.common.block.common.BaseChestBlock;
import org.confluence.mod.common.block.common.BiomeChestBlock;
import org.confluence.mod.common.data.saved.BrushData;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.network.s2c.BrushingColorPacketS2C;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.class})
public abstract class BlockBehaviourMixin {
    @ModifyExpressionValue(method={"getDestroyProgress"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getDigSpeed(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;)F")})
    private float deny(float original, @Local(argsOnly=true) BlockState state, @Local int i) {
        if (i > 30 && state.is(ModTags.Blocks.UNBREAKABLE_IF_CANNOT_HARVEST)) {
            return 0.0f;
        }
        return original;
    }

    @Mixin(value={BlockBehaviour.BlockStateBase.class})
    public static abstract class BlockStateBaseMixin {
        @Shadow
        @Final
        private boolean isAir;
        @Shadow
        @Nullable
        protected BlockBehaviour.BlockStateBase.Cache cache;

        @Shadow
        public abstract Block getBlock();

        @Shadow
        protected abstract BlockState asState();

        @Inject(method={"getCollisionShape(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;"}, at={@At(value="RETURN")}, cancellable=true)
        private void shimmer(BlockGetter pLevel, BlockPos pPos, CollisionContext pContext, CallbackInfoReturnable<VoxelShape> cir) {
            LivingEntity living;
            EntityCollisionContext context;
            Entity entity;
            if (this.cache == null || this.asState().getDestroySpeed(pLevel, pPos) == -1.0f) {
                return;
            }
            if (pContext instanceof EntityCollisionContext && (entity = (context = (EntityCollisionContext)pContext).getEntity()) instanceof LivingEntity && (living = (LivingEntity)entity).hasEffect(ModEffects.SHIMMER)) {
                cir.setReturnValue((Object)Shapes.empty());
            }
        }

        @Inject(method={"onRemove"}, at={@At(value="HEAD")})
        private void removeData(Level level, BlockPos pos, BlockState newState, boolean movedByPiston, CallbackInfo ci) {
            Map<ChunkPos, BrushData> dataMap;
            if (!(this.isAir || level.isClientSide || this.getBlock() == newState.getBlock() || (dataMap = ChunkBrushData.of(level).getDataMap()).isEmpty())) {
                BrushingColorPacketS2C.remove((ServerLevel)level, pos);
            }
        }

        @ModifyReturnValue(method={"getDestroySpeed"}, at={@At(value="RETURN")})
        private float modify(float original) {
            if (original == -1.0f) {
                return original;
            }
            if ((this.getBlock() instanceof BaseChestBlock || this.getBlock() instanceof BiomeChestBlock) && !((Boolean)this.asState().getValue((Property)StateProperties.UNLOCKED)).booleanValue()) {
                return -1.0f;
            }
            return original;
        }
    }
}

