/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixed;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Locale;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import org.confluence.mod.mixed.ILivingEntity;
import org.confluence.mod.util.ModUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Immunity {
    @Nullable
    public static Immunity getCause(DamageSource damageSource) {
        Entity directEntity = damageSource.getDirectEntity();
        ItemStack weaponItemStack = damageSource.getWeaponItem();
        if (weaponItemStack != null) {
            if (weaponItemStack.isEmpty()) {
                return directEntity instanceof Player ? (Immunity)weaponItemStack : null;
            }
            Item weaponItem = weaponItemStack.getItem();
            boolean fromConfluence = ModUtils.isFromConfluence(BuiltInRegistries.ITEM, weaponItem);
            if (fromConfluence && weaponItem instanceof SwordItem && directEntity instanceof Projectile) {
                Projectile projectile = (Projectile)directEntity;
                return (Immunity)projectile;
            }
            if (weaponItem instanceof Immunity) {
                Immunity im = (Immunity)weaponItem;
                return switch (im.confluence$getImmunityType().ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> im;
                    case 1 -> (Immunity)weaponItemStack;
                };
            }
            if (fromConfluence) {
                return (Immunity)weaponItemStack;
            }
        }
        if (directEntity instanceof Projectile) {
            Projectile proj = (Projectile)directEntity;
            if (directEntity instanceof Immunity) {
                Immunity im = (Immunity)directEntity;
                if (ModUtils.isFromConfluence(BuiltInRegistries.ENTITY_TYPE, directEntity.getType())) {
                    return switch (im.confluence$getImmunityType().ordinal()) {
                        default -> throw new MatchException(null, null);
                        case 0 -> (Immunity)proj.getType();
                        case 1 -> im;
                    };
                }
            }
        }
        return null;
    }

    public static void calculateInvTicks(DamageSource damageSource, LivingEntity victim) {
        Immunity cause = Immunity.getCause(damageSource);
        if (cause != null) {
            Object2IntMap<Immunity> invTicks = ILivingEntity.of(victim).confluence$getImmunityTicks();
            int time = cause.confluence$getImmunityDuration(damageSource);
            if (time != 0) {
                invTicks.put((Object)cause, time);
            }
        }
    }

    public static void tick(Entity entity) {
        if (entity instanceof ILivingEntity) {
            Object2IntMap<Immunity> invTicks;
            ILivingEntity living = (ILivingEntity)entity;
            int extraInvulnerableTicks = living.confluence$getExtraInvulnerableTicks();
            if (extraInvulnerableTicks > 0) {
                living.confluence$setExtraInvulnerableTicks(extraInvulnerableTicks - 1);
            }
            if ((invTicks = living.confluence$getImmunityTicks()).isEmpty()) {
                return;
            }
            ObjectIterator iterator = invTicks.object2IntEntrySet().iterator();
            while (iterator.hasNext()) {
                Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
                int remain = entry.getIntValue() - 1;
                if (remain < 0) {
                    iterator.remove();
                    continue;
                }
                entry.setValue(remain);
            }
        }
    }

    public Type confluence$getImmunityType();

    default public int confluence$getImmunityDuration(DamageSource damageSource) {
        LivingEntity living;
        SwordItem weaponItem;
        ItemStack weaponItemStack;
        Item item;
        Entity causeEntity = damageSource.getEntity();
        Immunity self = this;
        if (self instanceof ItemStack && (item = (weaponItemStack = (ItemStack)self).getItem()) instanceof SwordItem && ModUtils.isFromConfluence(BuiltInRegistries.ITEM, weaponItem = (SwordItem)item) && causeEntity instanceof LivingEntity && (living = (LivingEntity)causeEntity).getAttributes().hasAttribute(Attributes.ATTACK_SPEED)) {
            double speed = living.getAttribute(Attributes.ATTACK_SPEED).getValue();
            int time = (int)(20.0 / speed) - 1;
            return Math.max(0, time);
        }
        return 0;
    }

    public static enum Type implements StringRepresentable
    {
        STATIC,
        LOCAL;

        public static final Codec<Type> CODEC;

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
        }
    }
}

