/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixed;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import org.confluence.mod.Confluence;
import org.confluence.mod.api.event.CustomWorldIconRegisterEvent;
import org.confluence.mod.common.init.ModSecretSeeds;

public interface IWorldOptions {
    public static final long THE_CORRUPTION = 1L;
    public static final long THE_CRIMSON = 2L;
    public static final long DOUBLE_EVIL = 3L;
    public static final long HARDMODE = 4L;
    public static final long GRADUATED = 12L;
    public static final long SECRET_SEED = 0x7FFFFFFFFFFFFF00L;
    public static final long DW_MASK = ModSecretSeeds.DRUNK_WORLD.getFlag();
    public static final long NTB_MASK = ModSecretSeeds.NOT_THE_BEES.getFlag();
    public static final long FTW_MASK = ModSecretSeeds.FOR_THE_WORTHY.getFlag();
    public static final long C10_MASK = ModSecretSeeds.CELEBRATIONMK10.getFlag();
    public static final long TC_MASK = ModSecretSeeds.THE_CONSTANT.getFlag();
    public static final long NT_MASK = ModSecretSeeds.NO_TRAPS.getFlag();
    public static final long DDU_MASK = ModSecretSeeds.DONT_DIG_UP.getFlag();
    public static final long GFB_MASK = ModSecretSeeds.GET_FIXED_BOI.getFlag();
    public static final long BW_MASK = ModSecretSeeds.BOULDER_WORLD.getFlag();
    public static final ResourceLocation UNKNOWN_WORLD_ICON = Confluence.asResource("world_icon/unknown");
    public static final Long2ObjectMap<ResourceLocation> WORLD_ICON = (Long2ObjectMap)Util.make((Object)new Long2ObjectOpenHashMap(), map -> {
        IWorldOptions.registerWorldIcon((Long2ObjectMap<ResourceLocation>)map, 0L, "normal");
        map.put(DW_MASK | 3L, (Object)Confluence.asResource("world_icon/drunk_world"));
        map.put(DW_MASK | 3L | 4L, (Object)Confluence.asResource("world_icon/drunk_world_hardmode"));
        map.put(DW_MASK | 3L | 0xCL, (Object)Confluence.asResource("world_icon/drunk_world_graduated"));
        IWorldOptions.registerWorldIcon((Long2ObjectMap<ResourceLocation>)map, NTB_MASK, "not_the_bees");
        IWorldOptions.registerWorldIcon((Long2ObjectMap<ResourceLocation>)map, FTW_MASK, "for_the_worthy");
        IWorldOptions.registerWorldIcon((Long2ObjectMap<ResourceLocation>)map, C10_MASK, "celebrationmk10");
        IWorldOptions.registerWorldIcon((Long2ObjectMap<ResourceLocation>)map, TC_MASK, "the_constant");
        IWorldOptions.registerWorldIcon((Long2ObjectMap<ResourceLocation>)map, NT_MASK, "no_traps");
        IWorldOptions.registerWorldIcon((Long2ObjectMap<ResourceLocation>)map, DDU_MASK, "dont_dig_up");
        IWorldOptions.registerWorldIcon((Long2ObjectMap<ResourceLocation>)map, GFB_MASK, "get_fixed_boi");
        IWorldOptions.registerWorldIcon((Long2ObjectMap<ResourceLocation>)map, BW_MASK, "boulder_world");
        CustomWorldIconRegisterEvent event = new CustomWorldIconRegisterEvent((Long2ObjectMap<ResourceLocation>)map);
        ModLoader.postEventWrapContainerInModOrder((Event)event);
        map.putAll(event.getToAdd());
    });

    public void confluence$withSecretFlag(long var1);

    public long confluence$getSecretFlag();

    public WorldOptions confluence$copyWithoutSecretFlag();

    public static void registerWorldIcon(Long2ObjectMap<ResourceLocation> map, long flag, String base) {
        map.put(flag | 1L, (Object)Confluence.asResource("world_icon/" + base + "_corruption"));
        map.put(flag | 1L | 4L, (Object)Confluence.asResource("world_icon/" + base + "_corruption_hardmode"));
        map.put(flag | 1L | 0xCL, (Object)Confluence.asResource("world_icon/" + base + "_corruption_graduated"));
        map.put(flag | 2L, (Object)Confluence.asResource("world_icon/" + base + "_crimson"));
        map.put(flag | 2L | 4L, (Object)Confluence.asResource("world_icon/" + base + "_crimson_hardmode"));
        map.put(flag | 2L | 0xCL, (Object)Confluence.asResource("world_icon/" + base + "_crimson_graduated"));
    }

    public static ResourceLocation getWorldIcon(long flag) {
        return (ResourceLocation)WORLD_ICON.getOrDefault(flag, (Object)UNKNOWN_WORLD_ICON);
    }

    public static IWorldOptions of(WorldOptions options) {
        return (IWorldOptions)options;
    }
}

