/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixed;

import net.minecraft.server.MinecraftServer;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.client.handler.ClientPacketHandler;
import org.confluence.mod.common.worldgen.secret_seed.SecretSeed;
import org.jetbrains.annotations.NotNull;

public interface IMinecraftServer {
    public void confluence$updateSecretFlag(long var1);

    public long confluence$getSecretFlag();

    default public boolean confluence$matchesSecretFlag(long flag) {
        return IMinecraftServer.matchesSecretFlag(this.confluence$getSecretFlag(), flag);
    }

    default public boolean confluence$matchesSecretFlag(SecretSeed secretSeed) {
        return this.confluence$matchesSecretFlag(secretSeed.getFlag());
    }

    default public boolean confluence$equalsSecretFlag(long flag) {
        return IMinecraftServer.equalsSecretFlag(this.confluence$getSecretFlag(), flag);
    }

    public static boolean matchesSecretFlag(@NotNull MinecraftServer server, long flag) {
        return IMinecraftServer.of(server).confluence$matchesSecretFlag(flag);
    }

    public static boolean matchesSecretFlag(long secretFlag, long flag) {
        return (secretFlag & flag) != 0L;
    }

    public static boolean equalsSecretFlag(long secretFlag, long flag) {
        return (secretFlag & flag) == flag;
    }

    public static boolean matchesSecretFlag(long flag) {
        if (LibUtils.isLogicalClient()) {
            return IMinecraftServer.matchesSecretFlag(ClientPacketHandler.getSecretFlag(), flag);
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server != null && IMinecraftServer.matchesSecretFlag(server, flag);
    }

    public static boolean isHardmode(MinecraftServer server) {
        return IMinecraftServer.of(server).confluence$matchesSecretFlag(4L);
    }

    public static boolean isGraduated(MinecraftServer server) {
        return IMinecraftServer.of(server).confluence$matchesSecretFlag(12L);
    }

    public static IMinecraftServer of(MinecraftServer server) {
        return (IMinecraftServer)server;
    }
}

