/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixed;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.TriState;
import org.confluence.mod.common.init.ModDataComponentTypes;
import org.confluence.mod.common.item.GroupItem;
import org.confluence.mod.mixed.IClientItemStack;
import org.confluence.mod.mixed.IMobEffectInstance;
import org.confluence.mod.network.c2s.SwitchEffectEnabledPackedC2S;
import org.confluence.mod.util.ModUtils;
import org.jetbrains.annotations.ApiStatus;

public interface IAbstractContainerScreen {
    @ApiStatus.OverrideOnly
    default public TriState confluence$onMouseClicked(double mouseX, double mouseY, int button) {
        return TriState.DEFAULT;
    }

    @ApiStatus.OverrideOnly
    default public TriState confluence$onMouseReleased(double mouseX, double mouseY, int button) {
        return TriState.DEFAULT;
    }

    public static void switchEnabled(MobEffectInstance instance) {
        if (ModUtils.isSwitchableEffect(instance)) {
            IMobEffectInstance i;
            i.confluence$setEnabled(!(i = IMobEffectInstance.of(instance)).confluence$isEnabled());
            SwitchEffectEnabledPackedC2S.sendToServer((Holder<MobEffect>)instance.getEffect(), i.confluence$isEnabled());
        }
    }

    public static void makeTranslucent(GuiGraphics guiGraphics, MobEffectInstance instance, Runnable call) {
        if (IMobEffectInstance.of(instance).confluence$isEnabled()) {
            call.run();
        } else {
            RenderSystem.enableBlend();
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 0.5f);
            call.run();
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.disableBlend();
        }
    }

    public static void renderGroupBackground(GuiGraphics instance, ItemStack stack, int x, int y, Slot slot) {
        int id = stack.is((Item)GroupItem.getInstance()) ? ((GroupItem.Stacks)stack.getOrDefault(ModDataComponentTypes.GROUP_STACKS, (Object)GroupItem.Stacks.EMPTY)).id : IClientItemStack.of(stack).confluence$getGroupId();
        if (id != -1) {
            int maxX = x + 16;
            int maxY = y + 16;
            int index = slot.getContainerSlot();
            int color = 0x7F111111;
            if (IAbstractContainerScreen.hasNeighbour(index + 10, slot.container, id)) {
                instance.fill(x, y, maxX + 2, maxY + 2, color);
            } else {
                if (IAbstractContainerScreen.hasNeighbour(index + 1, slot.container, id)) {
                    instance.fill(maxX, y, maxX + 2, maxY, color);
                }
                if (IAbstractContainerScreen.hasNeighbour(index + 9, slot.container, id)) {
                    instance.fill(x, maxY, maxX, maxY + 2, color);
                }
                instance.fill(x, y, maxX, maxY, color);
            }
        }
    }

    private static boolean hasNeighbour(int index, Container container, int id) {
        return index % 9 != 0 && index >= 0 && index < container.getContainerSize() && IClientItemStack.of(container.getItem(index)).confluence$getGroupId() == id;
    }
}

