/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.waystones;

import com.mojang.datafixers.DSL;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.LibTags;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.util.LibUtils;
import org.confluence.lib.util.WipNotDisplayOutput;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.component.ValueComponent;
import org.confluence.mod.common.data.gen.data_map.ValueSubProvider;
import org.confluence.mod.common.init.ModBiomes;
import org.confluence.mod.common.init.ModTabs;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.integration.waystones.PylonBlock;

public class WaystonesHelper {
    public static final String MODID = "waystones";
    public static final boolean IS_LOADED = ModList.get().isLoaded("waystones");
    public static final Map<ResourceLocation, ResourceLocation> TYPE_TO_TEXTURE = new HashMap<ResourceLocation, ResourceLocation>();
    static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"confluence");
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"confluence");
    private static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"confluence");
    public static final DeferredBlock<Block> FOREST_PYLON = WaystonesHelper.register("forest_pylon", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK).mapColor(DyeColor.CYAN).lightLevel(state -> 10), (world, pos, biome) -> biome.is(Tags.Biomes.IS_FOREST) || biome.is(Tags.Biomes.IS_PLAINS));
    public static final DeferredBlock<Block> SNOW_PYLON = WaystonesHelper.register("snow_pylon", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK).mapColor(DyeColor.WHITE).lightLevel(state -> 10), (world, pos, biome) -> biome.is(Tags.Biomes.IS_SNOWY) || biome.is(Tags.Biomes.IS_ICY));
    public static final DeferredBlock<Block> DESERT_PYLON = WaystonesHelper.register("desert_pylon", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK).mapColor(DyeColor.YELLOW).lightLevel(state -> 10), (world, pos, biome) -> biome.is(Tags.Biomes.IS_DESERT) || biome.is(Tags.Biomes.IS_BADLANDS));
    public static final DeferredBlock<Block> CAVERN_PYLON = WaystonesHelper.register("cavern_pylon", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK).mapColor(DyeColor.GRAY).lightLevel(state -> 10), (world, pos, biome) -> world.dimensionType().bedWorks() && pos.getY() < world.getMinBuildHeight() + 104);
    public static final DeferredBlock<Block> OCEAN_PYLON = WaystonesHelper.register("ocean_pylon", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK).mapColor(DyeColor.BLUE).lightLevel(state -> 10), (world, pos, biome) -> biome.is(Tags.Biomes.IS_OCEAN));
    public static final DeferredBlock<Block> JUNGLE_PYLON = WaystonesHelper.register("jungle_pylon", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK).mapColor(DyeColor.GREEN).lightLevel(state -> 10), (world, pos, biome) -> biome.is(Tags.Biomes.IS_JUNGLE));
    public static final DeferredBlock<Block> HALLOW_PYLON = WaystonesHelper.register("hallow_pylon", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK).mapColor(DyeColor.LIGHT_BLUE).lightLevel(state -> 10), (world, pos, biome) -> biome.is(ModTags.Biomes.THE_HALLOW));
    public static final DeferredBlock<Block> MUSHROOM_PYLON = WaystonesHelper.register("mushroom_pylon", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK).mapColor(DyeColor.PURPLE).lightLevel(state -> 10), (world, pos, biome) -> biome.is(ModBiomes.GLOWING_MUSHROOM));
    public static final DeferredBlock<Block> UNIVERSAL_PYLON = WaystonesHelper.register("universal_pylon", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK).mapColor(DyeColor.BROWN).lightLevel(state -> 10), (world, pos, biome) -> true);
    public static final Supplier<BlockEntityType<PylonBlock.BEntity>> PYLON_ENTITY = BLOCK_ENTITY_TYPES.register("pylon_entity", () -> BlockEntityType.Builder.of(PylonBlock.BEntity::new, (Block[])((Block[])BLOCKS.getEntries().stream().map(DeferredHolder::get).toArray(Block[]::new))).build(DSL.remainderType()));

    private static DeferredBlock<Block> register(String name, BlockBehaviour.Properties properties, PylonBlock.Survive survive) {
        int count = BLOCKS.getEntries().size();
        DeferredBlock block = BLOCKS.register(name, () -> {
            try {
                return (Block)PylonBlock.class.getDeclaredConstructor(Integer.TYPE, BlockBehaviour.Properties.class, PylonBlock.Survive.class).newInstance(count, properties, survive);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().component(ConfluenceMagicLib.MOD_RARITY, (Object)ModRarity.BLUE)));
        TYPE_TO_TEXTURE.put(block.getId(), Confluence.asResource("textures/gui/pylon/" + block.getId().getPath() + ".png"));
        return block;
    }

    public static void register(IEventBus eventBus) {
        if (IS_LOADED) {
            BLOCKS.register(eventBus);
            BLOCK_ENTITY_TYPES.register(eventBus);
            ITEMS.register(eventBus);
            eventBus.addListener(WaystonesHelper::buildCreativeModeTabContents);
        }
    }

    private static void buildCreativeModeTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == ModTabs.MECHANICAL.get()) {
            WipNotDisplayOutput output = new WipNotDisplayOutput((CreativeModeTab.Output)event);
            ITEMS.getEntries().forEach(item -> output.accept((ItemLike)item.get()));
        }
    }

    public static void itemTag(Function<TagKey<Item>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>> consumer) {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item> wip = consumer.apply((TagKey<Item>)LibTags.Items.WIP);
        wip.addOptional(JUNGLE_PYLON.getId());
        wip.addOptional(HALLOW_PYLON.getId());
        wip.addOptional(MUSHROOM_PYLON.getId());
        wip.addOptional(UNIVERSAL_PYLON.getId());
    }

    public static void blockTags(Function<TagKey<Block>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>> consumer) {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> isTeleportTarget = consumer.apply((TagKey<Block>)TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"is_teleport_target")));
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> mineableWithPickaxe = consumer.apply((TagKey<Block>)BlockTags.MINEABLE_WITH_PICKAXE);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> needsOneLevel = consumer.apply(ModTags.Blocks.NEEDS_1_LEVEL);
        BLOCKS.getEntries().forEach(block -> {
            ResourceLocation id = block.getId();
            isTeleportTarget.addOptional(id);
            mineableWithPickaxe.addOptional(id);
            needsOneLevel.addOptional(id);
        });
    }

    public static void addTranslateKeys(BiConsumer<DeferredHolder<Block, ? extends Block>, String> consumer, boolean en) {
        if (en) {
            BLOCKS.getEntries().forEach(block -> consumer.accept((DeferredHolder<Block, ? extends Block>)block, LibUtils.toTitleCase((String)block.getId().getPath())));
        } else {
            consumer.accept((DeferredHolder<Block, ? extends Block>)FOREST_PYLON, "\u68ee\u6797\u6676\u5854");
            consumer.accept((DeferredHolder<Block, ? extends Block>)SNOW_PYLON, "\u96ea\u539f\u6676\u5854");
            consumer.accept((DeferredHolder<Block, ? extends Block>)DESERT_PYLON, "\u6c99\u6f20\u6676\u5854");
            consumer.accept((DeferredHolder<Block, ? extends Block>)CAVERN_PYLON, "\u6d1e\u7a74\u6676\u5854");
            consumer.accept((DeferredHolder<Block, ? extends Block>)OCEAN_PYLON, "\u6d77\u6d0b\u6676\u5854");
            consumer.accept((DeferredHolder<Block, ? extends Block>)JUNGLE_PYLON, "\u4e1b\u6797\u6676\u5854");
            consumer.accept((DeferredHolder<Block, ? extends Block>)HALLOW_PYLON, "\u795e\u5723\u6676\u5854");
            consumer.accept((DeferredHolder<Block, ? extends Block>)MUSHROOM_PYLON, "\u8611\u83c7\u6676\u5854");
            consumer.accept((DeferredHolder<Block, ? extends Block>)UNIVERSAL_PYLON, "\u4e07\u80fd\u6676\u5854");
        }
    }

    public static void appendValue(ValueSubProvider.Builder builder) {
        ValueComponent value = new ValueComponent(20000);
        ModLoadedCondition condition = new ModLoadedCondition(MODID);
        builder.add(FOREST_PYLON.getId(), (Object)value, false, new ICondition[]{condition});
        builder.add(SNOW_PYLON.getId(), (Object)value, false, new ICondition[]{condition});
        builder.add(DESERT_PYLON.getId(), (Object)value, false, new ICondition[]{condition});
        builder.add(CAVERN_PYLON.getId(), (Object)value, false, new ICondition[]{condition});
        builder.add(OCEAN_PYLON.getId(), (Object)value, false, new ICondition[]{condition});
        builder.add(JUNGLE_PYLON.getId(), (Object)value, false, new ICondition[]{condition});
        builder.add(HALLOW_PYLON.getId(), (Object)value, false, new ICondition[]{condition});
        builder.add(MUSHROOM_PYLON.getId(), (Object)value, false, new ICondition[]{condition});
        builder.add(UNIVERSAL_PYLON.getId(), (Object)new ValueComponent(200000), false, new ICondition[]{condition});
    }
}

