/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.terra_entity.npc_trade_lock.drawer;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.confluence.mod.Confluence;
import org.confluence.mod.integration.terra_entity.npc_trade_lock.PositionLock;
import org.confluence.terraentity.api.npc.trade.ITradeLock;
import org.confluence.terraentity.api.npc.trade.TradeLockRecipeDrawer;

public class PositionLockRecipeDrawer
extends TradeLockRecipeDrawer {
    private static final ResourceLocation SPRITE = Confluence.asResource("shop_lock/position");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int drawRecipe(ITradeLock lock, GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        MinMaxBounds.Ints x1;
        MinMaxBounds.Ints ints;
        if (!(lock instanceof PositionLock)) return y;
        PositionLock positionLock = (PositionLock)lock;
        try {
            x1 = ints = positionLock.x();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        MinMaxBounds.Ints y1 = ints = positionLock.y();
        MinMaxBounds.Ints z1 = ints = positionLock.z();
        ArrayList<MutableComponent> position = new ArrayList<MutableComponent>();
        position.add(Component.translatable((String)"confluence.trade_lock.drawer.position.title").append((Component)Component.literal((String)":")));
        this.updateWith("X", x1).ifPresent(position::add);
        this.updateWith("Y", y1).ifPresent(position::add);
        this.updateWith("Z", z1).ifPresent(position::add);
        int size = this.getRecipeSize();
        guiGraphics.blitSprite(SPRITE, x, y, size, size);
        this.drawTooltip(guiGraphics, x, y, size, size, mouseX, mouseY, position);
        return y + size;
    }

    private Optional<MutableComponent> updateWith(String axis, MinMaxBounds.Ints bounds) {
        if (bounds.min().isPresent() || bounds.max().isPresent()) {
            MutableComponent axisComponent = Component.literal((String)(axis + ": "));
            boolean minPresent = bounds.min().isPresent();
            if (minPresent) {
                axisComponent.append((Component)Component.literal((String)("\u2265 " + String.valueOf(bounds.min().get()))));
            }
            if (bounds.max().isPresent()) {
                if (minPresent) {
                    axisComponent.append((Component)Component.literal((String)" ")).append((Component)Component.translatable((String)"confluence.trade_lock.drawer.position.and")).append((Component)Component.literal((String)" "));
                }
                axisComponent.append((Component)Component.literal((String)("\u2264 " + String.valueOf(bounds.max().get()))));
            }
            return Optional.of(axisComponent);
        }
        return Optional.empty();
    }
}

