/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.terra_entity.npc_trade_lock.drawer;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import org.confluence.mod.Confluence;
import org.confluence.mod.integration.terra_entity.npc_trade_lock.FishingHookInFluidLock;
import org.confluence.terraentity.api.npc.trade.ITradeLock;
import org.confluence.terraentity.api.npc.trade.TradeLockRecipeDrawer;

public class FishingHookInFluidLockRecipeDrawer
extends TradeLockRecipeDrawer {
    private static final ResourceLocation REQUIRES_HOOK_SPRITE = Confluence.asResource("shop_lock/fishing_requires_hook");
    private static final ResourceLocation IN_LIQUID_SPRITE = Confluence.asResource("shop_lock/fishing_in_liquid");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int drawRecipe(ITradeLock lock, GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        boolean requiresFishingHook;
        List<TagKey<Fluid>> list;
        if (!(lock instanceof FishingHookInFluidLock)) return y;
        FishingHookInFluidLock fishingHookInFluidLock = (FishingHookInFluidLock)lock;
        List<TagKey<Fluid>> tags = list = fishingHookInFluidLock.tags();
        try {
            boolean bl;
            requiresFishingHook = bl = fishingHookInFluidLock.requiresFishingHook();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (requiresFishingHook) {
            int size = this.getRecipeSize();
            guiGraphics.blitSprite(REQUIRES_HOOK_SPRITE, x, y, size, size);
            this.drawTooltip(guiGraphics, x, y, size, size, mouseX, mouseY, I18n.get((String)"confluence.trade_lock.drawer.fishing.requires_hook", (Object[])new Object[0]));
            x += size;
        }
        if (tags.isEmpty()) return y;
        int size = this.getRecipeSize();
        for (TagKey<Fluid> tag : tags) {
            guiGraphics.blitSprite(IN_LIQUID_SPRITE, x, y, size, size);
            this.drawTooltip(guiGraphics, x, y, size, size, mouseX, mouseY, I18n.get((String)"confluence.trade_lock.drawer.fishing.fishing_in", (Object[])new Object[0]) + " " + String.valueOf(tag.location()));
            x += size;
        }
        return y;
    }
}

