/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.terra_entity.npc_trade_lock.drawer;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.data.saved.DateStamp;
import org.confluence.mod.integration.terra_entity.npc_trade_lock.DateLock;
import org.confluence.terraentity.api.npc.trade.ITradeLock;
import org.confluence.terraentity.api.npc.trade.TradeLockRecipeDrawer;

public class DateLockRecipeDrawer
extends TradeLockRecipeDrawer {
    public int drawRecipe(ITradeLock lock, GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (!(lock instanceof DateLock)) {
            return y;
        }
        DateLock dateLock = (DateLock)lock;
        String icon = "date";
        Object text = "Date: ";
        if (this.isChristmas(dateLock)) {
            icon = "date_christmas";
            text = I18n.get((String)"bestiary.confluence.filter.christmas.title", (Object[])new Object[0]) + ": ";
        } else if (this.isHalloweens(dateLock)) {
            icon = "date_halloweens";
            text = I18n.get((String)"bestiary.confluence.filter.halloween.title", (Object[])new Object[0]) + ": ";
        }
        int size = this.getRecipeSize();
        guiGraphics.blitSprite(Confluence.asResource("shop_lock/" + icon), x, y, size, size);
        this.drawTooltip(guiGraphics, x, y, size, size, mouseX, mouseY, (String)text + this.getDateString(dateLock));
        return y + size;
    }

    private boolean isHalloweens(DateLock lock) {
        return lock.equals(DateLock.HALLOWEENS);
    }

    private boolean isChristmas(DateLock lock) {
        return lock.equals(DateLock.CHRISTMAS);
    }

    private String getDateString(DateLock lock) {
        DateStamp from = lock.fromInclusive();
        DateStamp to = lock.toInclusive();
        String lunar = lock.isLunar() ? " (" + I18n.get((String)"confluence.trade_lock.drawer.date.lunar", (Object[])new Object[0]) + ") " : "";
        return String.format("%s%02d/%02d - %02d/%02d", lunar, from.month() + 1, from.day(), to.month() + 1, to.day());
    }
}

