/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.terra_entity.npc_trade_lock;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Calendar;
import net.minecraft.world.entity.player.Player;
import org.confluence.mod.api.lunar.Lunar;
import org.confluence.mod.common.data.saved.DateStamp;
import org.confluence.mod.integration.terra_entity.init.ModTradeLockProviderTypes;
import org.confluence.mod.util.DateUtils;
import org.confluence.terraentity.api.npc.trade.ITradeHolder;
import org.confluence.terraentity.api.npc.trade.ITradeLock;
import org.confluence.terraentity.registries.npc_trade_lock.TradeLockProvider;

public record DateLock(boolean isLunar, DateStamp fromInclusive, DateStamp toInclusive) implements ITradeLock
{
    public static final DateLock HALLOWEENS = new DateLock(false, new DateStamp(9, 10), new DateStamp(10, 1));
    public static final DateLock CHRISTMAS = new DateLock(false, new DateStamp(11, 15), new DateStamp(11, 31));
    public static final MapCodec<DateLock> CODEC = Codec.mapEither((MapCodec)Codec.STRING.xmap(string -> {
        if ("halloweens".equals(string)) {
            return HALLOWEENS;
        }
        if ("christmas".equals(string)) {
            return CHRISTMAS;
        }
        throw new IllegalArgumentException("Unknown date " + string);
    }, condition -> {
        if (condition == HALLOWEENS) {
            return "halloweens";
        }
        if (condition == CHRISTMAS) {
            return "christmas";
        }
        throw new IllegalArgumentException("Unknown date " + String.valueOf(condition));
    }).fieldOf("preset"), (MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.lenientOptionalFieldOf("is_lunar", (Object)false).forGetter(DateLock::isLunar), (App)DateStamp.CODEC.fieldOf("from_inclusive").forGetter(DateLock::fromInclusive), (App)DateStamp.CODEC.fieldOf("to_inclusive").forGetter(DateLock::toInclusive)).apply((Applicative)instance, DateLock::new))).xmap(Either::unwrap, Either::right);

    public boolean canTrade(Player player, ITradeHolder npc, int index) {
        int day;
        int month;
        if (this.isLunar) {
            Lunar lunar = DateUtils.getLunar();
            month = Math.abs(lunar.getMonth());
            day = lunar.getDay();
        } else {
            Calendar calendar = DateUtils.getCalendar();
            month = calendar.get(2);
            day = calendar.get(5);
        }
        return month >= this.fromInclusive.month() && month <= this.toInclusive.month() && day >= this.fromInclusive.day() && day <= this.toInclusive.day();
    }

    public TradeLockProvider getCodec() {
        return ModTradeLockProviderTypes.DATE_LOCK.get();
    }

    @Override
    public String toString() {
        return "DateLock{isLunar=" + this.isLunar + ", fromInclusive=" + String.valueOf(this.fromInclusive) + ", toInclusive=" + String.valueOf(this.toInclusive) + "}";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        DateStamp dateStamp;
        boolean isLunar1;
        if (o == this) {
            return true;
        }
        if (!(o instanceof DateLock)) return false;
        DateLock dateLock = (DateLock)o;
        try {
            boolean bl2;
            isLunar1 = bl2 = dateLock.isLunar();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        DateStamp fromInclusive1 = dateStamp = dateLock.fromInclusive();
        DateStamp toInclusive1 = dateStamp = dateLock.toInclusive();
        if (isLunar1 != this.isLunar) return false;
        if (!fromInclusive1.equals(this.fromInclusive)) return false;
        if (!toInclusive1.equals(this.toInclusive)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return 31 * (31 * (31 + Boolean.hashCode(this.isLunar)) + this.fromInclusive.hashCode()) + this.toInclusive.hashCode();
    }
}

